/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpRequestTestCase
extends HttpMessageTestCase
implements ToSmithyBuilder<HttpRequestTestCase> {
    private static final String METHOD = "method";
    private static final String URI = "uri";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String FORBID_QUERY_PARAMS = "forbidQueryParams";
    private static final String REQUIRE_QUERY_PARAMS = "requireQueryParams";
    private final String method;
    private final String uri;
    private final Map<String, String> queryParams;
    private final List<String> forbidQueryParams;
    private final List<String> requireQueryParams;

    private HttpRequestTestCase(Builder builder) {
        super(builder);
        this.method = (String)SmithyBuilder.requiredState((String)METHOD, (Object)builder.method);
        this.uri = (String)SmithyBuilder.requiredState((String)URI, (Object)builder.uri);
        this.queryParams = Collections.unmodifiableMap(new LinkedHashMap(builder.queryParams));
        this.forbidQueryParams = ListUtils.copyOf((Collection)builder.forbidQueryParams);
        this.requireQueryParams = ListUtils.copyOf((Collection)builder.requireQueryParams);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public List<String> getForbidQueryParams() {
        return this.forbidQueryParams;
    }

    public List<String> getRequireQueryParams() {
        return this.requireQueryParams;
    }

    public static HttpRequestTestCase fromNode(Node node) {
        Builder builder = HttpRequestTestCase.builder();
        HttpRequestTestCase.updateBuilderFromNode(builder, node);
        ObjectNode o = node.expectObjectNode();
        builder.method(o.expectStringMember(METHOD).getValue());
        builder.uri(o.expectStringMember(URI).getValue());
        o.getObjectMember(QUERY_PARAMS).ifPresent(headers -> headers.getStringMap().forEach((k, v) -> builder.putQueryParam((String)k, v.expectStringNode().getValue())));
        o.getArrayMember(FORBID_QUERY_PARAMS).ifPresent(params -> builder.forbidQueryParams(params.getElementsAs(StringNode::getValue)));
        o.getArrayMember(REQUIRE_QUERY_PARAMS).ifPresent(params -> builder.requireQueryParams(params.getElementsAs(StringNode::getValue)));
        return builder.build();
    }

    @Override
    public Node toNode() {
        ObjectNode.Builder node = super.toNode().expectObjectNode().toBuilder();
        node.withMember(METHOD, this.getMethod());
        node.withMember(URI, this.getUri());
        if (!this.queryParams.isEmpty()) {
            node.withMember(QUERY_PARAMS, (ToNode)ObjectNode.fromStringMap(this.getQueryParams()));
        }
        if (!this.forbidQueryParams.isEmpty()) {
            node.withMember(FORBID_QUERY_PARAMS, (ToNode)ArrayNode.fromStrings(this.getForbidQueryParams()));
        }
        if (!this.requireQueryParams.isEmpty()) {
            node.withMember(REQUIRE_QUERY_PARAMS, (ToNode)ArrayNode.fromStrings(this.getRequireQueryParams()));
        }
        return node.build();
    }

    public Builder toBuilder() {
        Builder builder = HttpRequestTestCase.builder().method(this.getMethod()).uri(this.getUri()).queryParams(this.getQueryParams()).forbidQueryParams(this.getForbidQueryParams()).requireQueryParams(this.getRequireQueryParams());
        this.updateBuilder(builder);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HttpMessageTestCase.Builder<Builder, HttpRequestTestCase> {
        private String method;
        private String uri;
        private final Map<String, String> queryParams = new LinkedHashMap<String, String>();
        private final List<String> forbidQueryParams = new ArrayList<String>();
        private final List<String> requireQueryParams = new ArrayList<String>();

        private Builder() {
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder queryParams(Map<String, String> queryParams) {
            this.queryParams.clear();
            this.queryParams.putAll(queryParams);
            return this;
        }

        public Builder putQueryParam(String key, String value) {
            this.queryParams.put(key, value);
            return this;
        }

        public Builder forbidQueryParams(List<String> forbidQueryParams) {
            this.forbidQueryParams.clear();
            this.forbidQueryParams.addAll(forbidQueryParams);
            return this;
        }

        public Builder requireQueryParams(List<String> requireQueryParams) {
            this.requireQueryParams.clear();
            this.requireQueryParams.addAll(requireQueryParams);
            return this;
        }

        public HttpRequestTestCase build() {
            return new HttpRequestTestCase(this);
        }
    }
}

