/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServerObject
extends Component
implements ToSmithyBuilder<ServerObject> {
    private final String url;
    private final String description;
    private final Map<String, ObjectNode> variables;

    private ServerObject(Builder builder) {
        super(builder);
        this.url = (String)SmithyBuilder.requiredState((String)"url", (Object)builder.url);
        this.description = builder.description;
        this.variables = (Map)builder.variables.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Map<String, ObjectNode> getVariables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return ((Builder)ServerObject.builder().extensions(this.getExtensions())).url(this.url).description(this.description).variables(this.variables);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("url", this.getUrl()).withOptionalMember("description", this.getDescription().map(Node::from));
        if (!this.variables.isEmpty()) {
            builder.withMember("variables", (ToNode)((ObjectNode)this.getVariables().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, ServerObject> {
        private String url;
        private String description;
        private final BuilderRef<Map<String, ObjectNode>> variables = BuilderRef.forOrderedMap();

        public ServerObject build() {
            return new ServerObject(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder variables(Map<String, ObjectNode> variables) {
            this.variables.clear();
            ((Map)this.variables.get()).putAll(variables);
            return this;
        }
    }
}

