/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.LinkObject;
import software.amazon.smithy.openapi.model.MediaTypeObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ResponseObject
extends Component
implements ToSmithyBuilder<ResponseObject> {
    private final String description;
    private final Map<String, Ref<ParameterObject>> headers;
    private final Map<String, MediaTypeObject> content;
    private final Map<String, Ref<LinkObject>> links;

    private ResponseObject(Builder builder) {
        super(builder);
        this.description = (String)SmithyBuilder.requiredState((String)"description", (Object)builder.description);
        this.headers = (Map)builder.headers.copy();
        this.content = (Map)builder.content.copy();
        this.links = (Map)builder.links.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<Ref<ParameterObject>> getHeader(String header) {
        for (Map.Entry<String, Ref<ParameterObject>> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(header)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Map<String, Ref<ParameterObject>> getHeaders() {
        return this.headers;
    }

    public Map<String, MediaTypeObject> getContent() {
        return this.content;
    }

    public Map<String, Ref<LinkObject>> getLinks() {
        return this.links;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("description", this.description);
        if (!this.headers.isEmpty()) {
            builder.withMember("headers", (ToNode)((ObjectNode)this.headers.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.content.isEmpty()) {
            builder.withMember("content", (ToNode)((ObjectNode)this.content.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.links.isEmpty()) {
            builder.withMember("links", (ToNode)((ObjectNode)this.links.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)ResponseObject.builder().extensions(this.getExtensions())).description(this.description).headers(this.headers).content(this.content).links(this.links);
    }

    public static final class Builder
    extends Component.Builder<Builder, ResponseObject> {
        private String description;
        private final BuilderRef<Map<String, Ref<ParameterObject>>> headers = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, MediaTypeObject>> content = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, Ref<LinkObject>>> links = BuilderRef.forSortedMap();

        private Builder() {
        }

        public ResponseObject build() {
            return new ResponseObject(this);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder putHeader(String name, Ref<ParameterObject> header) {
            ((Map)this.headers.get()).put(name, header);
            return this;
        }

        public Builder headers(Map<String, Ref<ParameterObject>> headers) {
            this.headers.clear();
            headers.forEach(this::putHeader);
            return this;
        }

        public Builder putContent(String name, MediaTypeObject mediaTypeObject) {
            ((Map)this.content.get()).put(name, mediaTypeObject);
            return this;
        }

        public Builder content(Map<String, MediaTypeObject> content) {
            this.content.clear();
            content.forEach(this::putContent);
            return this;
        }

        public Builder putLink(String name, Ref<LinkObject> link) {
            ((Map)this.links.get()).put(name, link);
            return this;
        }

        public Builder putLink(String name, LinkObject link) {
            return this.putLink(name, Ref.local(link));
        }

        public Builder links(Map<String, Ref<LinkObject>> links) {
            this.links.clear();
            links.forEach(this::putLink);
            return this;
        }
    }
}

