/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.EncodingObject;
import software.amazon.smithy.openapi.model.ExampleObject;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MediaTypeObject
extends Component
implements ToSmithyBuilder<MediaTypeObject> {
    private final Schema schema;
    private final ExampleObject example;
    private final Map<String, ExampleObject> examples = new TreeMap<String, ExampleObject>();
    private final Map<String, EncodingObject> encoding = new TreeMap<String, EncodingObject>();

    private MediaTypeObject(Builder builder) {
        super(builder);
        this.schema = builder.schema;
        this.example = builder.example;
        this.examples.putAll(builder.examples);
        this.encoding.putAll(builder.encoding);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Schema> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public Optional<ExampleObject> getExample() {
        return Optional.ofNullable(this.example);
    }

    public Map<String, ExampleObject> getExamples() {
        return this.examples;
    }

    public Map<String, EncodingObject> getEncoding() {
        return this.encoding;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("schema", this.getSchema()).withOptionalMember("example", this.getExample());
        if (!this.examples.isEmpty()) {
            builder.withMember("examples", (ToNode)this.examples.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.encoding.isEmpty()) {
            builder.withMember("encoding", (ToNode)this.encoding.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)MediaTypeObject.builder().extensions(this.getExtensions())).schema(this.schema).example(this.example == null ? null : this.example.toNode()).encoding(this.encoding);
        for (Map.Entry<String, ExampleObject> ex : this.examples.entrySet()) {
            builder.putExample(ex.getKey(), ex.getValue());
        }
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, MediaTypeObject> {
        private Schema schema;
        private ExampleObject example;
        private final Map<String, ExampleObject> examples = new TreeMap<String, ExampleObject>();
        private final Map<String, EncodingObject> encoding = new TreeMap<String, EncodingObject>();

        private Builder() {
        }

        public MediaTypeObject build() {
            return new MediaTypeObject(this);
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder example(Node example) {
            this.example = ExampleObject.fromNode(example);
            return this;
        }

        public Builder examples(Map<String, Node> examples) {
            this.examples.clear();
            for (Map.Entry<String, Node> example : examples.entrySet()) {
                this.examples.put(example.getKey(), ExampleObject.fromNode(example.getValue()));
            }
            return this;
        }

        public Builder putExample(String name, ExampleObject example) {
            this.examples.put(name, example);
            return this;
        }

        public Builder encoding(Map<String, EncodingObject> encoding) {
            this.encoding.clear();
            this.encoding.putAll(encoding);
            return this;
        }

        public Builder putEncoding(String name, EncodingObject encodingObject) {
            this.encoding.put(name, encodingObject);
            return this;
        }
    }
}

