/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientDiscoveredEndpointTrait;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.protocols.AbstractRestProtocol;
import software.amazon.smithy.utils.SetUtils;

public final class AwsRestJson1Protocol
extends AbstractRestProtocol<RestJson1Trait> {
    private static final Set<String> AWS_REQUEST_HEADERS = SetUtils.of((Object[])new String[]{"X-Amz-User-Agent", "X-Amzn-Trace-Id", "Amz-Sdk-Request", "Amz-Sdk-Invocation-Id"});
    private static final Set<String> AWS_RESPONSE_HEADERS = SetUtils.of((Object[])new String[]{"X-Amzn-Requestid", "X-Amzn-Errortype"});

    @Override
    public Class<RestJson1Trait> getProtocolType() {
        return RestJson1Trait.class;
    }

    @Override
    public Set<String> getProtocolRequestHeaders(Context<RestJson1Trait> context, OperationShape operationShape) {
        TreeSet<String> headers = new TreeSet<String>(super.getProtocolRequestHeaders(context, operationShape));
        headers.addAll(AWS_REQUEST_HEADERS);
        if (operationShape.hasTrait(ClientDiscoveredEndpointTrait.class)) {
            headers.add("X-Amz-Api-Version");
        }
        return headers;
    }

    @Override
    public Set<String> getProtocolResponseHeaders(Context<RestJson1Trait> context, OperationShape operationShape) {
        TreeSet<String> headers = new TreeSet<String>(super.getProtocolResponseHeaders(context, operationShape));
        headers.addAll(AWS_RESPONSE_HEADERS);
        return headers;
    }

    @Override
    public void updateDefaultSettings(Model model, OpenApiConfig config) {
        config.setUseJsonName(true);
        config.setDefaultTimestampFormat(TimestampFormatTrait.Format.EPOCH_SECONDS);
    }

    @Override
    String getDocumentMediaType(Context context, Shape operationOrError, AbstractRestProtocol.MessageType message) {
        return context.getConfig().getJsonContentType();
    }

    @Override
    Schema createDocumentSchema(Context<RestJson1Trait> context, Shape operationOrError, List<HttpBinding> bindings, AbstractRestProtocol.MessageType message) {
        if (bindings.isEmpty()) {
            return Schema.builder().type("object").build();
        }
        ShapeId container = bindings.get(0).getMember().getContainer();
        StructureShape containerShape = (StructureShape)context.getModel().expectShape(container, StructureShape.class);
        Set documentMemberNames = bindings.stream().map(HttpBinding::getMemberName).collect(Collectors.toSet());
        StructureShape.Builder containerShapeBuilder = containerShape.toBuilder();
        for (String memberName : containerShape.getAllMembers().keySet()) {
            if (documentMemberNames.contains(memberName)) continue;
            containerShapeBuilder.removeMember(memberName);
        }
        StructureShape cleanedShape = containerShapeBuilder.build();
        return context.getJsonSchemaConverter().convertShape((Shape)cleanedShape).getRootSchema();
    }
}

