/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;

public interface OpenApiMapper {
    default public byte getOrder() {
        return 0;
    }

    default public void updateDefaultSettings(Model model, OpenApiConfig config) {
    }

    default public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethodName, String path) {
        return operation;
    }

    default public PathItem updatePathItem(Context<? extends Trait> context, String path, PathItem pathItem) {
        return pathItem;
    }

    default public ParameterObject updateParameter(Context<? extends Trait> context, OperationShape operation, String httpMethodName, String path, ParameterObject parameterObject) {
        return parameterObject;
    }

    default public RequestBodyObject updateRequestBody(Context<? extends Trait> context, OperationShape operation, String httpMethodName, String path, RequestBodyObject requestBody) {
        return requestBody;
    }

    default public ResponseObject updateResponse(Context<? extends Trait> context, OperationShape operation, String status, String httpMethodName, String path, ResponseObject response) {
        return response;
    }

    default public void before(Context<? extends Trait> context, OpenApi.Builder builder) {
    }

    default public SecurityScheme updateSecurityScheme(Context<? extends Trait> context, Trait authTrait, SecurityScheme securityScheme) {
        return securityScheme;
    }

    default public Map<String, List<String>> updateSecurity(Context<? extends Trait> context, Shape shape, SecuritySchemeConverter<? extends Trait> converter, Map<String, List<String>> requirement) {
        return requirement;
    }

    default public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
        return openapi;
    }

    default public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
        return node;
    }

    public static OpenApiMapper compose(List<OpenApiMapper> mappers) {
        final ArrayList<OpenApiMapper> sorted = new ArrayList<OpenApiMapper>(mappers);
        sorted.sort(Comparator.comparingInt(OpenApiMapper::getOrder));
        return new OpenApiMapper(){

            @Override
            public void updateDefaultSettings(Model model, OpenApiConfig config) {
                for (OpenApiMapper plugin : sorted) {
                    plugin.updateDefaultSettings(model, config);
                }
            }

            @Override
            public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethodName, String path) {
                for (OpenApiMapper plugin : sorted) {
                    if (operation == null) {
                        return null;
                    }
                    operation = plugin.updateOperation(context, shape, operation, httpMethodName, path);
                }
                return operation;
            }

            @Override
            public PathItem updatePathItem(Context<? extends Trait> context, String path, PathItem pathItem) {
                for (OpenApiMapper plugin : sorted) {
                    if (pathItem == null) {
                        return null;
                    }
                    pathItem = plugin.updatePathItem(context, path, pathItem);
                }
                return pathItem;
            }

            @Override
            public ParameterObject updateParameter(Context<? extends Trait> context, OperationShape operation, String httpMethodName, String path, ParameterObject parameterObject) {
                for (OpenApiMapper plugin : sorted) {
                    if (parameterObject == null) {
                        return null;
                    }
                    parameterObject = plugin.updateParameter(context, operation, httpMethodName, path, parameterObject);
                }
                return parameterObject;
            }

            @Override
            public RequestBodyObject updateRequestBody(Context<? extends Trait> context, OperationShape shape, String httpMethodName, String path, RequestBodyObject requestBody) {
                for (OpenApiMapper plugin : sorted) {
                    if (requestBody == null) {
                        return null;
                    }
                    requestBody = plugin.updateRequestBody(context, shape, httpMethodName, path, requestBody);
                }
                return requestBody;
            }

            @Override
            public ResponseObject updateResponse(Context<? extends Trait> context, OperationShape shape, String status, String httpMethodName, String path, ResponseObject response) {
                for (OpenApiMapper plugin : sorted) {
                    if (response == null) {
                        return null;
                    }
                    response = plugin.updateResponse(context, shape, status, httpMethodName, path, response);
                }
                return response;
            }

            @Override
            public SecurityScheme updateSecurityScheme(Context<? extends Trait> context, Trait authTrait, SecurityScheme securityScheme) {
                for (OpenApiMapper plugin : sorted) {
                    if (securityScheme == null) {
                        return null;
                    }
                    securityScheme = plugin.updateSecurityScheme(context, authTrait, securityScheme);
                }
                return securityScheme;
            }

            @Override
            public Map<String, List<String>> updateSecurity(Context<? extends Trait> context, Shape shape, SecuritySchemeConverter<? extends Trait> converter, Map<String, List<String>> requirement) {
                for (OpenApiMapper plugin : sorted) {
                    if (requirement == null || requirement.isEmpty()) {
                        return null;
                    }
                    requirement = plugin.updateSecurity(context, shape, converter, requirement);
                }
                return requirement;
            }

            @Override
            public void before(Context<? extends Trait> context, OpenApi.Builder builder) {
                for (OpenApiMapper plugin : sorted) {
                    plugin.before(context, builder);
                }
            }

            @Override
            public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
                for (OpenApiMapper plugin : sorted) {
                    openapi = plugin.after(context, openapi);
                }
                return openapi;
            }

            @Override
            public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
                for (OpenApiMapper plugin : sorted) {
                    node = plugin.updateNode(context, openapi, node);
                }
                return node;
            }
        };
    }
}

