/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.List;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;

public final class Context {
    private final Model model;
    private final ServiceShape service;
    private final JsonSchemaConverter jsonSchemaConverter;
    private final Protocol protocol;
    private final OpenApiProtocol openApiProtocol;
    private final SchemaDocument schemas;
    private final List<SecuritySchemeConverter> securitySchemeConverters;

    public Context(Model model, ServiceShape service, JsonSchemaConverter jsonSchemaConverter, Protocol protocol, OpenApiProtocol openApiProtocol, SchemaDocument schemas, List<SecuritySchemeConverter> securitySchemeConverters) {
        this.model = model;
        this.service = service;
        this.jsonSchemaConverter = jsonSchemaConverter;
        this.protocol = protocol;
        this.openApiProtocol = openApiProtocol;
        this.schemas = schemas;
        this.securitySchemeConverters = securitySchemeConverters;
    }

    public Model getModel() {
        return this.model;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public ObjectNode getConfig() {
        return this.jsonSchemaConverter.getConfig();
    }

    public JsonSchemaConverter getJsonSchemaConverter() {
        return this.jsonSchemaConverter;
    }

    public String getProtocolName() {
        return this.protocol.getName();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public OpenApiProtocol getOpenApiProtocol() {
        return this.openApiProtocol;
    }

    public Schema getSchema(String pointer) {
        return (Schema)this.schemas.getDefinition(pointer).orElseThrow(() -> new OpenApiException("Expected JSON schema definition not found: " + pointer));
    }

    public String getPointer(ToShapeId shapeId) {
        return this.getJsonSchemaConverter().getRefStrategy().toPointer(shapeId.toShapeId(), this.getConfig());
    }

    public Schema createRef(ToShapeId shapeId) {
        return Schema.builder().ref(this.getPointer(shapeId)).build();
    }

    public List<SecuritySchemeConverter> getSecuritySchemeConverters() {
        return this.securitySchemeConverters;
    }

    public boolean usesHttpCredentials() {
        return this.getSecuritySchemeConverters().stream().anyMatch(SecuritySchemeConverter::usesHttpCredentials);
    }
}

