/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.security;

import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.SetUtils;

public final class AwsV4
implements SecuritySchemeConverter {
    private static final String AUTH_HEADER = "Authorization";
    private static final Set<String> REQUEST_HEADERS = SetUtils.of((Object[])new String[]{"Authorization", "Date", "X-Amz-Date", "X-Amz-Target", "X-Amz-Security-Token"});

    @Override
    public String getAuthSchemeName() {
        return "aws.v4";
    }

    @Override
    public SecurityScheme createSecurityScheme(Context context) {
        return ((SecurityScheme.Builder)SecurityScheme.builder().type("apiKey").description("AWS Signature Version 4 authentication").name(AUTH_HEADER).in("header").putExtension("x-amazon-apigateway-authtype", (Node)Node.from((String)"awsSigv4"))).build();
    }

    @Override
    public Set<String> getAuthRequestHeaders() {
        return REQUEST_HEADERS;
    }
}

