/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public final class StreamingTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(StreamingTrait.class)) {
            return Collections.emptyList();
        }
        List<ValidationEvent> events = this.validateStreamingTargets(model);
        events.addAll(this.validateAllEventStreamMembers(model));
        return events;
    }

    private List<ValidationEvent> validateStreamingTargets(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NeighborProvider provider = NeighborProviderIndex.of(model).getReverseProvider();
        Set streamingStructures = model.shapes(MemberShape.class).filter(member -> member.getMemberTrait(model, StreamingTrait.class).isPresent()).map(member -> model.expectShape(member.getContainer())).collect(Collectors.toSet());
        for (Shape shape : streamingStructures) {
            for (Relationship rel : provider.getNeighbors(shape)) {
                if (rel.getRelationshipType() == RelationshipType.INPUT || rel.getRelationshipType() == RelationshipType.OUTPUT || rel.getRelationshipType().getDirection() != RelationshipDirection.DIRECTED) continue;
                events.add(this.error(rel.getShape(), String.format("This shape has an invalid `%s` relationship to a structure, `%s`, that contains a stream", new Object[]{rel.getRelationshipType(), shape.getId()})));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateAllEventStreamMembers(Model model) {
        return model.shapes(UnionShape.class).filter(shape -> shape.hasTrait(StreamingTrait.class)).flatMap(shape -> this.validateUnionMembers(model, (UnionShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateUnionMembers(Model model, UnionShape shape) {
        String invalidMembers = shape.getAllMembers().values().stream().map(em -> Pair.of((Object)em.getMemberName(), (Object)model.getShape(em.getTarget()).orElse(null))).filter(pair -> pair.getRight() != null && !(pair.getRight() instanceof StructureShape)).map(Pair::getLeft).sorted().collect(Collectors.joining(", "));
        if (!invalidMembers.isEmpty()) {
            return ListUtils.of((Object)this.error(shape, String.format("Each member of an event stream union must target a structure shape, but the following union members do not: [%s]", invalidMembers)));
        }
        return Collections.emptyList();
    }
}

