/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class CleanStructureAndUnionMembers
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        Model result = this.removeMembersFromContainers(transformer, removed, model);
        return transformer.removeShapes(result, this.findMembersThatNeedRemoval(result, removed));
    }

    private Model removeMembersFromContainers(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        ArrayList<Shape> replacements = new ArrayList<Shape>(this.getStructureReplacements(model, removed));
        replacements.addAll(this.getUnionReplacements(model, removed));
        return transformer.replaceShapes(model, replacements);
    }

    private Collection<Shape> getStructureReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asStructureShape, entry -> {
            StructureShape.Builder builder = ((StructureShape)entry.getKey()).toBuilder();
            ((List)entry.getValue()).forEach(member -> builder.removeMember(member.getMemberName()));
            return builder.build();
        });
    }

    private Collection<Shape> getUnionReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asUnionShape, entry -> {
            UnionShape.Builder builder = ((UnionShape)entry.getKey()).toBuilder();
            ((List)entry.getValue()).forEach(member -> builder.removeMember(member.getMemberName()));
            return builder.build();
        });
    }

    private <S extends Shape> Collection<Shape> createUpdatedShapes(Model model, Collection<Shape> removed, Function<Shape, Optional<S>> containerShapeMapper, Function<Map.Entry<S, List<MemberShape>>, S> entryMapperAndFactory) {
        return removed.stream().flatMap(shape -> OptionalUtils.stream(shape.asMemberShape())).flatMap(member -> OptionalUtils.stream(model.getShape(member.getContainer()).flatMap(containerShapeMapper).map(container -> Pair.of((Object)container, (Object)member)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList()))).entrySet().stream().map(entryMapperAndFactory).collect(Collectors.toList());
    }

    private Collection<Shape> findMembersThatNeedRemoval(Model model, Collection<Shape> removed) {
        Set removedIds = removed.stream().map(Shape::getId).collect(Collectors.toSet());
        HashSet<Shape> removeMembers = new HashSet<Shape>();
        model.shapes(StructureShape.class).flatMap(shape -> shape.getAllMembers().values().stream()).filter(value -> removedIds.contains(value.getTarget())).forEach(removeMembers::add);
        model.shapes(UnionShape.class).flatMap(shape -> shape.getAllMembers().values().stream()).filter(value -> removedIds.contains(value.getTarget())).forEach(removeMembers::add);
        return removeMembers;
    }
}

