/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;

public final class NumberNode
extends Node {
    private final Number value;
    private String stringCache;

    public NumberNode(Number value, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.value = Objects.requireNonNull(value);
        this.stringCache = value.toString();
    }

    public Number getValue() {
        return this.value;
    }

    public boolean isNaturalNumber() {
        return !this.isFloatingPointNumber();
    }

    public boolean isFloatingPointNumber() {
        return this.value instanceof Float || this.value instanceof Double || this.value instanceof BigDecimal || this.stringCache.contains(".");
    }

    @Override
    public NodeType getType() {
        return NodeType.NUMBER;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.numberNode(this);
    }

    @Override
    public NumberNode expectNumberNode(String errorMessage) {
        return this;
    }

    @Override
    public Optional<NumberNode> asNumberNode() {
        return Optional.of(this);
    }

    public boolean equals(Object other) {
        return other instanceof NumberNode && this.stringCache.equals(((NumberNode)other).stringCache);
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + this.stringCache.hashCode();
    }

    public String toString() {
        return this.stringCache;
    }
}

