/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.transform.ModelTransformException;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.DependencyGraph;

final class ReplaceShapes {
    private final Collection<? extends Shape> replacements;

    ReplaceShapes(Collection<? extends Shape> replacements) {
        this.replacements = Objects.requireNonNull(replacements);
    }

    Model transform(ModelTransformer transformer, Model model) {
        Collection<Shape> shouldReplace = this.determineShapesToReplace(model);
        if (shouldReplace.isEmpty()) {
            return model;
        }
        this.assertShapeTypeChangesSound(model, shouldReplace);
        Model.Builder builder = this.createReplacedModelBuilder(model, shouldReplace);
        this.updateMixins(model, builder, shouldReplace);
        builder.addShapes(this.getUpdatedContainers(model, shouldReplace));
        return transformer.removeShapes(builder.build(), this.getRemovedMembers(model, shouldReplace));
    }

    private Collection<Shape> determineShapesToReplace(Model model) {
        TreeSet<Shape> result = new TreeSet<Shape>((a, b) -> {
            if (a.isMemberShape() ^ b.isMemberShape()) {
                return a.isMemberShape() ? 1 : -1;
            }
            return a.compareTo((Shape)b);
        });
        for (Shape shape : this.replacements) {
            if (Objects.equals(shape, model.getShape(shape.getId()).orElse(null))) continue;
            result.add(shape);
        }
        return result;
    }

    private void assertShapeTypeChangesSound(Model model, Collection<Shape> shouldReplace) {
        for (Shape shape : shouldReplace) {
            model.getShape(shape.getId()).ifPresent(previousShape -> {
                if (shape.getType() != previousShape.getType() && !this.isReplacementValid(shape, (Shape)previousShape)) {
                    throw new ModelTransformException(String.format("Cannot change the type of %s from %s to %s", new Object[]{previousShape.getId(), previousShape.getType(), shape.getType()}));
                }
            });
        }
    }

    private boolean isReplacementValid(Shape left, Shape right) {
        if (left instanceof CollectionShape && right instanceof CollectionShape) {
            return true;
        }
        if (left instanceof StructureShape && right instanceof UnionShape) {
            return true;
        }
        if (left instanceof UnionShape && right instanceof StructureShape) {
            return true;
        }
        return left instanceof SimpleShape && right instanceof SimpleShape;
    }

    private Model.Builder createReplacedModelBuilder(Model model, Collection<Shape> shouldReplace) {
        Model.Builder builder = model.toBuilder();
        for (Shape shape : shouldReplace) {
            builder.addShape(shape);
            builder.addShapes(shape.members());
        }
        return builder;
    }

    private void updateMixins(Model model, Model.Builder builder, Collection<Shape> replacements) {
        HashMap<ShapeId, Shape> updatedShapes = new HashMap<ShapeId, Shape>();
        for (Shape replaced : replacements) {
            updatedShapes.put(replaced.getId(), replaced);
        }
        DependencyGraph dependencyGraph = new DependencyGraph();
        for (Shape shape : model.toSet()) {
            if (shape.isMemberShape() || !shape.hasTrait(MixinTrait.ID) && shape.getMixins().isEmpty()) continue;
            dependencyGraph.add((Object)shape.getId());
            dependencyGraph.addDependencies((Object)shape.getId(), shape.getMixins());
        }
        for (Shape shape : replacements) {
            dependencyGraph.add((Object)shape.getId());
            if (shape.isMemberShape()) continue;
            dependencyGraph.setDependencies((Object)shape.getId(), shape.getMixins());
        }
        for (ShapeId toRebuild : dependencyGraph.toSortedList()) {
            Shape shape;
            if (updatedShapes.containsKey(toRebuild)) {
                shape = (Shape)updatedShapes.get(toRebuild);
            } else {
                if (!model.getShape(toRebuild).isPresent()) continue;
                shape = model.getShape(toRebuild).get();
            }
            if (shape.getMixins().isEmpty()) continue;
            Object shapeBuilder = Shape.shapeToBuilder(shape);
            for (ShapeId mixin : shape.getMixins()) {
                Shape mixinShape = updatedShapes.containsKey(mixin) ? (Shape)updatedShapes.get(mixin) : model.expectShape(mixin);
                ((AbstractShapeBuilder)shapeBuilder).addMixin(mixinShape);
            }
            Shape rebuilt = (Shape)shapeBuilder.build();
            builder.addShape(rebuilt);
            updatedShapes.put(rebuilt.getId(), rebuilt);
        }
    }

    private Set<Shape> getRemovedMembers(Model model, Collection<Shape> beingReplaced) {
        HashSet<Shape> removedMembers = new HashSet<Shape>();
        for (Shape currentShape : beingReplaced) {
            model.getShape(currentShape.getId()).ifPresent(previousShape -> {
                Map<String, MemberShape> currentMembers = currentShape.getAllMembers();
                for (MemberShape previousMember : previousShape.members()) {
                    if (currentMembers.containsKey(previousMember.getMemberName())) continue;
                    removedMembers.add(previousMember);
                }
            });
        }
        return removedMembers;
    }

    private Set<Shape> getUpdatedContainers(Model model, Collection<Shape> shouldReplace) {
        HashMap containerToMemberMapping = new HashMap();
        for (Shape shape : shouldReplace) {
            shape.asMemberShape().ifPresent(member -> this.findMostUpToDateShape(member.getContainer(), model, shouldReplace).ifPresent(container -> {
                if (!ReplaceShapes.isMemberPresent(member, container)) {
                    containerToMemberMapping.computeIfAbsent(container, c -> new ArrayList()).add(member);
                }
            }));
        }
        HashSet<Shape> containersToUpdate = new HashSet<Shape>(containerToMemberMapping.size());
        for (Map.Entry entry : containerToMemberMapping.entrySet()) {
            Shape container = (Shape)entry.getKey();
            List members = (List)entry.getValue();
            Object builder = Shape.shapeToBuilder(container);
            for (MemberShape member2 : members) {
                ((AbstractShapeBuilder)builder).addMember(member2);
            }
            containersToUpdate.add((Shape)builder.build());
        }
        return containersToUpdate;
    }

    private static boolean isMemberPresent(MemberShape member, Shape shape) {
        return shape.getMember(member.getMemberName()).filter(m -> m == member).isPresent();
    }

    private Optional<Shape> findMostUpToDateShape(ShapeId shapeId, Model model, Collection<Shape> shouldReplace) {
        for (Shape shape : shouldReplace) {
            if (!shape.getId().equals(shapeId)) continue;
            return Optional.of(shape);
        }
        return model.getShape(shapeId);
    }
}

