/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.UniqueItemsTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

final class UniqueItemsPlugin
extends MemberAndShapeTraitPlugin<CollectionShape, ArrayNode, UniqueItemsTrait> {
    UniqueItemsPlugin() {
        super(CollectionShape.class, ArrayNode.class, UniqueItemsTrait.class);
    }

    @Override
    protected void check(Shape shape, UniqueItemsTrait trait, ArrayNode value, NodeValidatorPlugin.Context context, NodeValidatorPlugin.Emitter emitter) {
        HashSet<Node> uniqueNodes = new HashSet<Node>(value.getElements());
        if (uniqueNodes.size() != value.size()) {
            ArrayList<Node> duplicateNodes = new ArrayList<Node>(value.getElements());
            for (Node uniqueNode : uniqueNodes) {
                duplicateNodes.remove(uniqueNode);
            }
            LinkedHashSet<String> duplicateValues = new LinkedHashSet<String>();
            for (Node duplicateNode : duplicateNodes) {
                duplicateValues.add(duplicateNode.toString());
            }
            emitter.accept(value, String.format("Value provided for `%s` must have unique items, but the following items had multiple entries: [`%s`]", shape.getId(), String.join((CharSequence)"`, `", duplicateValues)));
        }
    }
}

