/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.FunctionalUtils;

public final class UnreferencedShapes {
    private final Predicate<Shape> keepFilter;

    public UnreferencedShapes() {
        this(FunctionalUtils.alwaysTrue());
    }

    public UnreferencedShapes(Predicate<Shape> keepFilter) {
        this.keepFilter = keepFilter;
    }

    public Set<Shape> compute(Model model) {
        Walker shapeWalker = new Walker(NeighborProviderIndex.of(model).getProvider());
        Set connected = model.shapes(ServiceShape.class).flatMap(service -> shapeWalker.walkShapes((Shape)service).stream()).collect(Collectors.toSet());
        model.shapes().filter(shape -> shape.hasTrait(TraitDefinition.class)).flatMap(shape -> shapeWalker.walkShapes((Shape)shape).stream()).forEach(connected::add);
        return model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(FunctionalUtils.not(connected::contains)).filter(FunctionalUtils.not(Prelude::isPreludeShape)).filter(this.keepFilter).collect(Collectors.toSet());
    }
}

