/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraitValidatorsTrait
extends AbstractTrait
implements ToSmithyBuilder<TraitValidatorsTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#traitValidators");
    private final Map<String, Validator> validators;

    private TraitValidatorsTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.validators = (Map)builder.validators.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = ObjectNode.builder();
        builder.sourceLocation(this.getSourceLocation());
        this.validators.forEach((k, v) -> builder.withMember((String)k, v.toNode()));
        return builder.build();
    }

    public Builder toBuilder() {
        Builder builder = (Builder)TraitValidatorsTrait.builder().sourceLocation(this.getSourceLocation());
        this.validators.forEach(builder::putValidator);
        return builder;
    }

    public Map<String, Validator> getValidators() {
        return this.validators;
    }

    public static final class Builder
    extends AbstractTraitBuilder<TraitValidatorsTrait, Builder> {
        private final BuilderRef<Map<String, Validator>> validators = BuilderRef.forOrderedMap();

        private Builder() {
        }

        public TraitValidatorsTrait build() {
            return new TraitValidatorsTrait(this);
        }

        public Builder putValidator(String idSuffix, Validator validator) {
            ((Map)this.validators.get()).put(idSuffix, validator);
            return this;
        }

        public Builder removeValidator(String idSuffix) {
            ((Map)this.validators.get()).remove(idSuffix);
            return this;
        }
    }

    public static final class Validator
    implements ToNode {
        private final Selector selector;
        private final String message;
        private final Severity severity;

        public Validator(Selector selector, String message) {
            this(selector, message, Severity.ERROR);
        }

        public Validator(Selector selector, String message, Severity severity) {
            this.selector = selector;
            this.message = message;
            this.severity = severity;
        }

        public static Validator fromNode(Node node) {
            ObjectNode obj = node.expectObjectNode();
            Selector selector = Selector.fromNode(obj.expectStringMember("selector"));
            String message = obj.getStringMember("message").map(StringNode::getValue).orElse(null);
            Severity severity = obj.getStringMember("severity").map(Severity::fromNode).orElse(Severity.ERROR);
            return new Validator(selector, message, severity);
        }

        @Override
        public Node toNode() {
            ObjectNode.Builder builder = ObjectNode.builder();
            builder.withMember("selector", this.selector.toString());
            if (this.message != null) {
                builder.withMember("message", this.message);
            }
            if (this.severity != Severity.ERROR) {
                builder.withMember("severity", this.severity.toString());
            }
            return builder.build();
        }

        public Selector getSelector() {
            return this.selector;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(this.message);
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Validator validator = (Validator)o;
            return this.selector.equals(validator.selector) && Objects.equals(this.message, validator.message) && this.severity == validator.severity;
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.message, this.severity);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public TraitValidatorsTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)TraitValidatorsTrait.builder().sourceLocation(value);
            value.expectObjectNode().getMembers().forEach((k, v) -> {
                String key = k.expectStringNode().getValue();
                ObjectNode valueNode = v.expectObjectNode();
                builder.putValidator(key, Validator.fromNode(valueNode));
            });
            TraitValidatorsTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

