/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Optional;
import software.amazon.smithy.model.neighbor.RelationshipDirection;

public enum RelationshipType {
    RESOURCE("resource", RelationshipDirection.DIRECTED),
    OPERATION("operation", RelationshipDirection.DIRECTED),
    COLLECTION_OPERATION("collectionOperation", RelationshipDirection.DIRECTED),
    INSTANCE_OPERATION("instanceOperation", RelationshipDirection.DIRECTED),
    BOUND("bound", RelationshipDirection.INVERTED),
    PUT("put", RelationshipDirection.DIRECTED),
    CREATE("create", RelationshipDirection.DIRECTED),
    READ("read", RelationshipDirection.DIRECTED),
    UPDATE("update", RelationshipDirection.DIRECTED),
    DELETE("delete", RelationshipDirection.DIRECTED),
    LIST("list", RelationshipDirection.DIRECTED),
    IDENTIFIER("identifier", RelationshipDirection.DIRECTED),
    PROPERTY("property", RelationshipDirection.DIRECTED),
    MEMBER_CONTAINER(null, RelationshipDirection.INVERTED),
    MEMBER_TARGET(null, RelationshipDirection.DIRECTED),
    INPUT("input", RelationshipDirection.DIRECTED),
    OUTPUT("output", RelationshipDirection.DIRECTED),
    ERROR("error", RelationshipDirection.DIRECTED),
    ENUM_MEMBER("member", RelationshipDirection.DIRECTED),
    INT_ENUM_MEMBER("member", RelationshipDirection.DIRECTED),
    LIST_MEMBER("member", RelationshipDirection.DIRECTED),
    SET_MEMBER("member", RelationshipDirection.DIRECTED),
    MAP_KEY("member", RelationshipDirection.DIRECTED),
    MAP_VALUE("member", RelationshipDirection.DIRECTED),
    STRUCTURE_MEMBER("member", RelationshipDirection.DIRECTED),
    UNION_MEMBER("member", RelationshipDirection.DIRECTED),
    TRAIT("trait", RelationshipDirection.DIRECTED),
    MIXIN("mixin", RelationshipDirection.DIRECTED),
    ID_REF(null, RelationshipDirection.DIRECTED);

    private String selectorLabel;
    private RelationshipDirection direction;

    private RelationshipType(String selectorLabel, RelationshipDirection direction) {
        this.selectorLabel = selectorLabel;
        this.direction = direction;
    }

    public Optional<String> getSelectorLabel() {
        return Optional.ofNullable(this.selectorLabel);
    }

    public RelationshipDirection getDirection() {
        return this.direction;
    }

    public boolean isMemberBinding() {
        switch (this.ordinal()) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public boolean isOperationBinding() {
        return this.isInstanceOperationBinding() || this.isCollectionOperationBinding();
    }

    public boolean isInstanceOperationBinding() {
        switch (this.ordinal()) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isCollectionOperationBinding() {
        switch (this.ordinal()) {
            case 2: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }
}

