/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader.sourcecontext;

import java.util.Collection;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.sourcecontext.DefaultSourceLoader;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public interface SourceContextLoader {
    public Collection<Line> loadContext(FromSourceLocation var1);

    public static SourceContextLoader createLineBasedLoader(int defaultCodeLines) {
        return new DefaultSourceLoader(defaultCodeLines, null);
    }

    public static SourceContextLoader createModelAwareLoader(Model model, int defaultCodeLinesHint) {
        return new DefaultSourceLoader(defaultCodeLinesHint, model);
    }

    public static final class Line {
        private final int lineNumber;
        private final CharSequence content;

        public Line(int lineNumber, CharSequence content) {
            this.lineNumber = lineNumber;
            this.content = content;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public CharSequence getContent() {
            return this.content;
        }

        public int hashCode() {
            return Objects.hash(this.lineNumber, this.content);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            return this.lineNumber == line.lineNumber && Objects.equals(this.content, line.content);
        }

        public String toString() {
            return this.lineNumber + " | " + this.content;
        }
    }
}

