/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Objects;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.AddedDefaultTrait;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.utils.SmithyUnstableApi;

public class NullableIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;

    public NullableIndex(Model model) {
        this.model = new WeakReference<Model>(model);
    }

    public static NullableIndex of(Model model) {
        return model.getKnowledge(NullableIndex.class, NullableIndex::new);
    }

    public boolean isMemberNullable(MemberShape member) {
        return this.isMemberNullable(member, CheckMode.CLIENT);
    }

    public boolean isMemberNullable(MemberShape member, CheckMode checkMode) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape container = m.expectShape(member.getContainer());
        Shape target = m.expectShape(member.getTarget());
        switch (container.getType()) {
            case STRUCTURE: {
                return checkMode.isStructureMemberOptional(container.asStructureShape().get(), member, target);
            }
            case UNION: 
            case SET: {
                return false;
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    @Deprecated
    public final boolean isNullable(ToShapeId shapeId) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape shape = m.getShape(shapeId.toShapeId()).orElse(null);
        if (shape == null) {
            return false;
        }
        switch (shape.getType()) {
            case MEMBER: {
                return this.isMemberNullableInV1(m, shape.asMemberShape().get());
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return shape.hasTrait(BoxTrait.class);
            }
        }
        return true;
    }

    private boolean isMemberNullableInV1(Model model, MemberShape member) {
        Shape container = model.getShape(member.getContainer()).orElse(null);
        Shape target = model.getShape(member.getTarget()).orElse(null);
        if (container == null || target == null) {
            return false;
        }
        switch (container.getType()) {
            case STRUCTURE: {
                return this.isMemberNullable(member, CheckMode.CLIENT_ZERO_VALUE_V1_NO_INPUT);
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    @SmithyUnstableApi
    public static boolean isShapeSetToDefaultZeroValueInV1(MemberShape member, Shape target) {
        Node defaultValue;
        DefaultTrait memberDefault = member.getTrait(DefaultTrait.class).orElse(null);
        Node node = defaultValue = memberDefault == null ? null : memberDefault.toNode();
        if (defaultValue == null || defaultValue.isNullNode()) {
            return false;
        }
        ShapeType targetType = target.getType();
        return NullableIndex.isDefaultZeroValueOfTypeInV1(defaultValue, targetType);
    }

    @SmithyUnstableApi
    public static boolean isDefaultZeroValueOfTypeInV1(Node defaultValue, ShapeType targetType) {
        if (defaultValue == null) {
            return false;
        }
        switch (targetType) {
            case BOOLEAN: {
                return defaultValue.asBooleanNode().map(BooleanNode::getValue).filter(value -> value == false).isPresent();
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case INT_ENUM: {
                return defaultValue.asNumberNode().filter(NumberNode::isZero).isPresent();
            }
        }
        return false;
    }

    public static enum CheckMode {
        CLIENT{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (member.hasTrait(ClientOptionalTrait.class) || container.hasTrait(InputTrait.class)) {
                    return true;
                }
                return SERVER.isStructureMemberOptional(container, member, target);
            }
        }
        ,
        CLIENT_CAREFUL{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (target instanceof StructureShape || target instanceof UnionShape) {
                    return true;
                }
                return CLIENT.isStructureMemberOptional(container, member, target);
            }
        }
        ,
        CLIENT_ZERO_VALUE_V1{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                return container.hasTrait(InputTrait.class) || CLIENT_ZERO_VALUE_V1_NO_INPUT.isStructureMemberOptional(container, member, target);
            }
        }
        ,
        CLIENT_ZERO_VALUE_V1_NO_INPUT{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (member.hasTrait(AddedDefaultTrait.class) || member.hasTrait(ClientOptionalTrait.class)) {
                    return true;
                }
                return !NullableIndex.isShapeSetToDefaultZeroValueInV1(member, target);
            }
        }
        ,
        SERVER{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                return !member.hasTrait(RequiredTrait.class) && !member.hasNonNullDefault();
            }
        };


        abstract boolean isStructureMemberOptional(StructureShape var1, MemberShape var2, Shape var3);
    }
}

