/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ShapeModifier;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.ValidationEvent;

abstract class LoadOperation
implements FromSourceLocation {
    final Version version;

    LoadOperation(Version version) {
        this.version = version;
    }

    abstract void accept(Visitor var1);

    static final class ModelVersion
    extends LoadOperation {
        final SourceLocation sourceLocation;

        ModelVersion(Version version, SourceLocation sourceLocation) {
            super(version);
            this.sourceLocation = sourceLocation;
        }

        @Override
        void accept(Visitor visitor) {
            visitor.modelVersion(this);
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.sourceLocation;
        }
    }

    static final class Event
    extends LoadOperation {
        final ValidationEvent event;

        Event(ValidationEvent event) {
            super(Version.UNKNOWN);
            this.event = event;
        }

        @Override
        void accept(Visitor visitor) {
            visitor.event(this);
        }
    }

    static final class ForwardReference
    extends LoadOperation {
        final String namespace;
        final String name;
        private final BiFunction<ShapeId, ShapeType, ValidationEvent> receiver;

        ForwardReference(String namespace, String name, BiFunction<ShapeId, ShapeType, ValidationEvent> receiver) {
            super(Version.UNKNOWN);
            this.namespace = namespace;
            this.name = name;
            this.receiver = receiver;
        }

        @Override
        void accept(Visitor visitor) {
            visitor.forwardReference(this);
        }

        ValidationEvent resolve(ShapeId id, ShapeType type) {
            return this.receiver.apply(id, type);
        }
    }

    static final class DefineShape
    extends LoadOperation
    implements ToShapeId {
        private final AbstractShapeBuilder<?, ?> builder;
        private Set<ShapeId> dependencies;
        private Map<String, MemberShape.Builder> members;
        private List<ShapeModifier> modifiers;

        DefineShape(Version version, AbstractShapeBuilder<?, ?> builder) {
            super(version);
            if (builder.getShapeType() == ShapeType.MEMBER) {
                throw new UnsupportedOperationException("Members must be added to top-level DefineShape instances");
            }
            this.builder = builder;
        }

        @Override
        void accept(Visitor visitor) {
            visitor.defineShape(this);
        }

        @Override
        public ShapeId toShapeId() {
            return this.builder.getId();
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.builder.getSourceLocation();
        }

        Set<ShapeId> dependencies() {
            return this.dependencies == null ? Collections.emptySet() : this.dependencies;
        }

        void addDependency(ShapeId id) {
            if (this.dependencies == null) {
                this.dependencies = new LinkedHashSet<ShapeId>();
            }
            this.dependencies.add(id);
        }

        ShapeType getShapeType() {
            return this.builder.getShapeType();
        }

        AbstractShapeBuilder<?, ?> builder() {
            return this.builder;
        }

        void addMember(MemberShape.Builder member) {
            if (this.members == null) {
                this.members = new LinkedHashMap<String, MemberShape.Builder>();
            }
            this.members.put(member.getId().getMember().get(), member);
        }

        boolean hasMember(String memberName) {
            return this.members != null && this.members.containsKey(memberName);
        }

        Map<String, MemberShape.Builder> memberBuilders() {
            return this.members == null ? Collections.emptyMap() : this.members;
        }

        List<ShapeModifier> modifiers() {
            return this.modifiers == null ? Collections.emptyList() : this.modifiers;
        }

        void addModifier(ShapeModifier modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<ShapeModifier>();
            }
            this.modifiers.add(modifier);
        }
    }

    static final class ApplyTrait
    extends LoadOperation {
        final String namespace;
        final ShapeId target;
        final ShapeId trait;
        final Node value;
        final SourceLocation location;

        ApplyTrait(Version version, SourceLocation location, String namespace, ShapeId target, ShapeId trait, Node value) {
            super(version);
            this.namespace = namespace;
            this.target = target;
            this.trait = trait;
            this.value = value;
            this.location = location;
        }

        static ApplyTrait from(ShapeId target, Trait trait) {
            return new ApplyTrait(Version.UNKNOWN, trait.getSourceLocation(), target.getNamespace(), target, trait.toShapeId(), trait.toNode());
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.location;
        }

        @Override
        void accept(Visitor visitor) {
            visitor.applyTrait(this);
        }
    }

    static final class PutMetadata
    extends LoadOperation {
        final String key;
        final Node value;

        PutMetadata(Version version, String key, Node value) {
            super(version);
            this.key = key;
            this.value = value;
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.value.getSourceLocation();
        }

        @Override
        void accept(Visitor visitor) {
            visitor.putMetadata(this);
        }
    }

    static interface Visitor {
        public void putMetadata(PutMetadata var1);

        public void applyTrait(ApplyTrait var1);

        public void defineShape(DefineShape var1);

        public void forwardReference(ForwardReference var1);

        public void event(Event var1);

        public void modelVersion(ModelVersion var1);
    }
}

