/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;

public final class BooleanNode
extends Node {
    private final boolean value;

    public BooleanNode(boolean value, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public NodeType getType() {
        return NodeType.BOOLEAN;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.booleanNode(this);
    }

    @Override
    public BooleanNode expectBooleanNode(String errorMessage) {
        return this;
    }

    @Override
    public BooleanNode expectBooleanNode(Supplier<String> errorMessage) {
        return this;
    }

    @Override
    public Optional<BooleanNode> asBooleanNode() {
        return Optional.of(this);
    }

    public boolean equals(Object other) {
        return other instanceof BooleanNode && this.value == ((BooleanNode)other).value;
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + (this.value ? 1 : 0);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

