/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.Pair;

public final class ServiceValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(model, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        Walker walker = new Walker(NeighborProviderIndex.of(model).getProvider());
        Set<Shape> serviceClosure = walker.walkShapes(service);
        Map<String, List<ShapeId>> conflicts = ValidationUtils.findDuplicateShapeNames(serviceClosure);
        if (conflicts.isEmpty()) {
            return Collections.emptyList();
        }
        ConflictDetector detector = new ConflictDetector(model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry<String, List<ShapeId>> entry : conflicts.entrySet()) {
            List<ShapeId> ids = entry.getValue();
            for (int i = 0; i < ids.size(); ++i) {
                Shape subject = model.expectShape(ids.get(i));
                for (int j = 0; j < ids.size(); ++j) {
                    Shape other;
                    Severity severity;
                    if (i == j || (severity = detector.detect(subject, other = model.expectShape(ids.get(j)))) == null) continue;
                    events.add(this.conflictingNames(severity, service, subject, other));
                    events.add(this.conflictingNames(severity, service, other, subject));
                }
            }
        }
        return events;
    }

    private ValidationEvent conflictingNames(Severity severity, ServiceShape shape, Shape subject, Shape other) {
        String declaration = severity == Severity.DANGER || severity == Severity.ERROR ? "must" : "should";
        return ValidationEvent.builder().id(this.getName()).severity(severity).shape(subject).message(String.format("Shape name `%s` conflicts with `%s` in the `%s` service closure. These shapes in the closure of a service %s have case-insensitively unique names regardless of their namespaces.", subject.getId().getName(), other.getId(), shape.getId(), declaration)).build();
    }

    private static final class ConflictDetector {
        private static final EnumMap<ShapeType, Severity> FORBIDDEN = new EnumMap(ShapeType.class);
        private final Model model;
        private final Map<Pair<ShapeId, ShapeId>, Severity> cache = new HashMap<Pair<ShapeId, ShapeId>, Severity>();

        ConflictDetector(Model model) {
            this.model = model;
        }

        Severity detect(Shape a, Shape b) {
            Pair cacheKey;
            if (a == null || b == null) {
                return null;
            }
            Pair pair = cacheKey = a.getId().compareTo(b.getId()) < 0 ? Pair.of((Object)a.getId(), (Object)b.getId()) : Pair.of((Object)b.getId(), (Object)a.getId());
            if (this.cache.containsKey(cacheKey)) {
                return this.cache.get(cacheKey);
            }
            Severity result = this.detectConflicts(a, b);
            this.cache.put((Pair<ShapeId, ShapeId>)cacheKey, result);
            return result;
        }

        private Severity detectConflicts(Shape a, Shape b) {
            if (FORBIDDEN.containsKey((Object)a.getType())) {
                return FORBIDDEN.get((Object)a.getType());
            }
            if (FORBIDDEN.containsKey((Object)b.getType())) {
                return FORBIDDEN.get((Object)b.getType());
            }
            if (a.getType() != b.getType()) {
                return Severity.DANGER;
            }
            if (!a.getAllTraits().equals(b.getAllTraits())) {
                return Severity.DANGER;
            }
            Severity memberConflict = this.detectMemberConflicts(a, b);
            if (memberConflict == Severity.WARNING || memberConflict == Severity.DANGER || memberConflict == Severity.ERROR) {
                return memberConflict;
            }
            if (a instanceof SimpleShape) {
                return Severity.NOTE;
            }
            return Severity.WARNING;
        }

        private Severity detectMemberConflicts(Shape a, Shape b) {
            if (a instanceof MemberShape) {
                MemberShape aMember = (MemberShape)a;
                MemberShape bMember = (MemberShape)b;
                Shape aTarget = this.model.getShape(aMember.getTarget()).orElse(null);
                Shape bTarget = this.model.getShape(bMember.getTarget()).orElse(null);
                return this.detect(aTarget, bTarget);
            }
            if (a instanceof CollectionShape) {
                CollectionShape aCollection = (CollectionShape)a;
                CollectionShape bCollection = (CollectionShape)b;
                return this.detect(aCollection.getMember(), bCollection.getMember());
            }
            return null;
        }

        static {
            FORBIDDEN.put(ShapeType.RESOURCE, Severity.ERROR);
            FORBIDDEN.put(ShapeType.OPERATION, Severity.ERROR);
            FORBIDDEN.put(ShapeType.SERVICE, Severity.ERROR);
            FORBIDDEN.put(ShapeType.MAP, Severity.DANGER);
            FORBIDDEN.put(ShapeType.STRUCTURE, Severity.DANGER);
            FORBIDDEN.put(ShapeType.UNION, Severity.DANGER);
        }
    }
}

