/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

abstract class AbstractNeighborSelector
implements InternalSelector {
    private final List<String> relTypes;
    private final boolean includeTraits;

    AbstractNeighborSelector(List<String> relTypes) {
        this.relTypes = relTypes;
        this.includeTraits = relTypes.contains("trait");
    }

    @Override
    public final boolean push(Context context, Shape shape, InternalSelector.Receiver next) {
        NeighborProvider resolvedProvider = this.getNeighborProvider(context, this.includeTraits);
        for (Relationship rel : resolvedProvider.getNeighbors(shape)) {
            if (!this.matches(rel) || this.emitMatchingRel(context, rel, next)) continue;
            return false;
        }
        return true;
    }

    abstract NeighborProvider getNeighborProvider(Context var1, boolean var2);

    abstract boolean emitMatchingRel(Context var1, Relationship var2, InternalSelector.Receiver var3);

    private boolean matches(Relationship rel) {
        return rel.getNeighborShape().isPresent() && rel.getRelationshipType() != RelationshipType.MEMBER_CONTAINER && (this.relTypes.isEmpty() || this.relTypes.contains(AbstractNeighborSelector.getRelType(rel)));
    }

    private static String getRelType(Relationship rel) {
        return rel.getSelectorLabel().orElse("");
    }
}

