/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.testrunner;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.testrunner.SmithyTestCase;

public final class SmithyTestSuite {
    private static final Logger LOGGER = Logger.getLogger(SmithyTestSuite.class.getName());
    private static final String DEFAULT_TEST_CASE_LOCATION = "errorfiles";
    private final List<SmithyTestCase> cases = new ArrayList<SmithyTestCase>();
    private Supplier<ModelAssembler> modelAssemblerFactory = ModelAssembler::new;

    private SmithyTestSuite() {
    }

    public static SmithyTestSuite runner() {
        return new SmithyTestSuite();
    }

    public static Stream<Object[]> defaultParameterizedTestSource(Class<?> contextClass) {
        ClassLoader classLoader = contextClass.getClassLoader();
        ModelAssembler assembler = Model.assembler(classLoader).discoverModels(classLoader);
        return SmithyTestSuite.runner().setModelAssemblerFactory(assembler::copy).addTestCasesFromUrl(contextClass.getResource(DEFAULT_TEST_CASE_LOCATION)).parameterizedTestSource();
    }

    public Stream<Object[]> parameterizedTestSource() {
        return this.cases.stream().map(testCase -> {
            Callable<SmithyTestCase.Result> callable = this.createTestCaseCallable((SmithyTestCase)testCase);
            Callable<SmithyTestCase.Result> wrappedCallable = () -> ((SmithyTestCase.Result)callable.call()).unwrap();
            return new Object[]{testCase.getModelLocation(), wrappedCallable};
        });
    }

    public SmithyTestSuite addTestCase(SmithyTestCase testCase) {
        this.cases.add(testCase);
        return this;
    }

    public SmithyTestSuite addTestCasesFromDirectory(Path modelDirectory) {
        SmithyTestSuite smithyTestSuite;
        block8: {
            Stream<Path> files = Files.walk(modelDirectory, new FileVisitOption[0]);
            try {
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                    String filename = file.toString();
                    return filename.endsWith(".json") || filename.endsWith(".smithy");
                }).map(file -> SmithyTestCase.fromModelFile(file.toString())).forEach(this::addTestCase);
                smithyTestSuite = this;
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return smithyTestSuite;
    }

    public SmithyTestSuite addTestCasesFromUrl(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Only file URLs are supported by the testrunner: " + url);
        }
        try {
            return this.addTestCasesFromDirectory(Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyTestSuite setModelAssemblerFactory(Supplier<ModelAssembler> modelAssemblerFactory) {
        this.modelAssemblerFactory = Objects.requireNonNull(modelAssemblerFactory);
        return this;
    }

    public Stream<Callable<SmithyTestCase.Result>> testCaseCallables() {
        return this.cases.stream().map(this::createTestCaseCallable);
    }

    private Callable<SmithyTestCase.Result> createTestCaseCallable(SmithyTestCase testCase) {
        boolean useLegacyValidationMode = this.isLegacyValidationRequired(testCase);
        return () -> {
            ModelAssembler assembler = this.modelAssemblerFactory.get();
            assembler.addImport(testCase.getModelLocation());
            if (useLegacyValidationMode) {
                assembler.putProperty("LEGACY_VALIDATION_MODE", true);
            }
            return testCase.createResult(assembler.assemble());
        };
    }

    private boolean isLegacyValidationRequired(SmithyTestCase testCase) {
        TreeSet<String> criticalEvents = new TreeSet<String>();
        TreeSet<String> nonCriticalEvents = new TreeSet<String>();
        for (ValidationEvent event : testCase.getExpectedEvents()) {
            if (SmithyTestSuite.isCriticalValidationEvent(event)) {
                criticalEvents.add(event.getId());
                continue;
            }
            nonCriticalEvents.add(event.getId());
        }
        if (!criticalEvents.isEmpty() && !nonCriticalEvents.isEmpty()) {
            LOGGER.warning(String.format("Test suite `%s` relies on the emission of non-critical validation events after critical validation events were emitted. This test case should be refactored so that critical validation events are tested using separate test cases from non-critical events. Critical events: %s. Non-critical events: %s", testCase.getModelLocation(), criticalEvents, nonCriticalEvents));
            return true;
        }
        return false;
    }

    private static boolean isCriticalValidationEvent(ValidationEvent event) {
        if (ValidationUtils.isCriticalEvent(event.getId())) {
            return true;
        }
        return event.getId().equals("Model") && event.getSeverity() == Severity.ERROR;
    }

    public Result run() {
        return this.run(ForkJoinPool.commonPool());
    }

    public Result run(ExecutorService executorService) {
        List<SmithyTestCase.Result> failedResults = Collections.synchronizedList(new ArrayList());
        List callables = this.testCaseCallables().collect(Collectors.toList());
        try {
            for (Future<SmithyTestCase.Result> result2 : executorService.invokeAll(callables)) {
                SmithyTestCase.Result testCaseResult = this.waitOnFuture(result2);
                if (!testCaseResult.isInvalid()) continue;
                failedResults.add(testCaseResult);
            }
            Result result = new Result(callables.size() - failedResults.size(), failedResults);
            if (failedResults.isEmpty()) {
                Result result2 = result;
                return result2;
            }
            try {
                throw new Error(result);
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                throw new Error("Error executing test suite: " + e.getMessage(), e);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private SmithyTestCase.Result waitOnFuture(Future<SmithyTestCase.Result> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error("Error executing test case: " + e.getMessage(), cause);
        }
    }

    public static final class Result {
        private final int successCount;
        private final List<SmithyTestCase.Result> failedResults;

        Result(int successCount, List<SmithyTestCase.Result> failedResults) {
            this.successCount = successCount;
            this.failedResults = Collections.unmodifiableList(failedResults);
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public List<SmithyTestCase.Result> getFailedResults() {
            return this.failedResults;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Smithy validation test runner encountered %d successful result(s), and %d failed result(s)", this.getSuccessCount(), this.getFailedResults().size()));
            this.getFailedResults().forEach(failed -> builder.append('\n').append(failed.toString()).append('\n'));
            return builder.toString();
        }
    }

    public static final class Error
    extends RuntimeException {
        public final Result result;

        Error(Result result) {
            super(result.toString());
            this.result = result;
        }

        Error(String message, Throwable previous) {
            super(message, previous);
            this.result = new Result(0, Collections.emptyList());
        }
    }
}

