/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.FunctionalUtils;

public final class UnreferencedShapes {
    private static final Selector SERVICE_SHAPES = Selector.parse("service");
    private final Selector rootShapeSelector;
    private final Predicate<Shape> keepFilter;

    public UnreferencedShapes(Predicate<Shape> keepFilter, Selector rootShapeSelector) {
        this.keepFilter = keepFilter;
        this.rootShapeSelector = rootShapeSelector;
    }

    public UnreferencedShapes() {
        this(FunctionalUtils.alwaysTrue());
    }

    public UnreferencedShapes(Selector selector) {
        this(FunctionalUtils.alwaysTrue(), selector);
    }

    public UnreferencedShapes(Predicate<Shape> keepFilter) {
        this(keepFilter, SERVICE_SHAPES);
    }

    public Set<Shape> compute(Model model) {
        NeighborProvider baseProvider = NeighborProviderIndex.of(model).getProvider();
        NeighborProvider providerWithIdRefRelationships = NeighborProvider.withIdRefRelationships(model, baseProvider);
        Walker shapeWalker = new Walker(providerWithIdRefRelationships);
        HashSet connected = new HashSet();
        Predicate<Relationship> traversed = rel -> !connected.contains(rel.getNeighborShapeId());
        Set<Shape> rootShapes = this.rootShapeSelector.select(model);
        for (Shape root : rootShapes) {
            shapeWalker.iterateShapes(root, traversed).forEachRemaining(shape -> connected.add(shape.getId()));
        }
        for (Shape trait : model.getShapesWithTrait(TraitDefinition.class)) {
            shapeWalker.iterateShapes(trait, traversed).forEachRemaining(shape -> connected.add(shape.getId()));
        }
        HashSet<Shape> result = new HashSet<Shape>();
        for (Shape shape2 : model.toSet()) {
            if (shape2.isMemberShape() || connected.contains(shape2.getId()) || Prelude.isPreludeShape(shape2) || !this.keepFilter.test(shape2)) continue;
            result.add(shape2);
        }
        return result;
    }
}

