/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;

public final class LineValidationEventFormatter
implements ValidationEventFormatter {
    @Override
    public String format(ValidationEvent event) {
        String hint;
        String message = event.getMessage();
        String reason = event.getSuppressionReason().orElse(null);
        if (reason != null) {
            message = message + " (" + reason + ")";
        }
        if ((hint = (String)event.getHint().orElse(null)) != null) {
            message = message + " [" + hint + "]";
        }
        return String.format("[%s] %s: %s | %s %s:%s:%s", event.getSeverity(), event.getShapeId().map(ShapeId::toString).orElse("-"), message, event.getId(), event.getSourceLocation().getFilename(), event.getSourceLocation().getLine(), event.getSourceLocation().getColumn());
    }
}

