/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class RootSelector
implements InternalSelector {
    private final InternalSelector selector;
    private final int id;

    RootSelector(InternalSelector selector, int id) {
        this.selector = selector;
        this.id = id;
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        for (Shape v : context.getRootResult(this.id)) {
            if (next.apply(context, v) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }

    @Override
    public InternalSelector.ContainsShape containsShapeOptimization(Context context, Shape shape) {
        return context.getRootResult(this.id).contains(shape) ? InternalSelector.ContainsShape.YES : InternalSelector.ContainsShape.NO;
    }
}

