/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class HttpApiKeyAuthTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        Set<ServiceShape> serviceShapesWithTrait = model.getServiceShapesWithTrait(HttpApiKeyAuthTrait.class);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape serviceShape : serviceShapesWithTrait) {
            HttpApiKeyAuthTrait trait = serviceShape.expectTrait(HttpApiKeyAuthTrait.class);
            trait.getScheme().ifPresent(scheme -> {
                if (trait.getIn() != HttpApiKeyAuthTrait.Location.HEADER) {
                    events.add(this.error((Shape)serviceShape, trait, String.format("The httpApiKeyAuth trait must have an `in` value of `header` when a `scheme` is provided, found: %s", new Object[]{trait.getIn()})));
                }
            });
        }
        return events;
    }
}

