/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Formatter;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;

public final class ContextualValidationEventFormatter
implements ValidationEventFormatter {
    private final SourceContextLoader sourceContextLoader = SourceContextLoader.createLineBasedLoader(1);

    @Override
    public String format(ValidationEvent event) {
        StringWriter writer = new StringWriter();
        Formatter formatter = new Formatter(writer);
        formatter.format("%s: %s (%s)%n", event.getSeverity(), event.getShapeId().map(ShapeId::toString).orElse("-"), event.getId());
        if (event.getSourceLocation() != SourceLocation.NONE) {
            String humanReadableFilename = this.getHumanReadableFilename(event.getSourceLocation());
            Collection<SourceContextLoader.Line> lines = this.sourceContextLoader.loadContext(event.getSourceLocation());
            if (lines.isEmpty()) {
                formatter.format("     @ %s%n", event.getSourceLocation());
            } else {
                formatter.format("     @ %s%n", humanReadableFilename);
                formatter.format("     |%n", new Object[0]);
                formatter.format("%4d | %s%n", event.getSourceLocation().getLine(), lines.iterator().next().getContent());
                formatter.format("     | %" + event.getSourceLocation().getColumn() + "s%n", "^");
            }
        }
        formatter.format("     = %s%n", event.getMessage().replace("\n", "       \n"));
        formatter.flush();
        return writer.toString();
    }

    private String getHumanReadableFilename(SourceLocation source) {
        String filename = source.getFilename();
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        return filename;
    }
}

