/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class VariableGetSelector
implements InternalSelector {
    private final String variableName;

    VariableGetSelector(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        for (Shape v : this.getShapes(context)) {
            if (next.apply(context, v) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }

    private Set<Shape> getShapes(Context context) {
        return context.getVars().getOrDefault(this.variableName, Collections.emptySet());
    }

    @Override
    public InternalSelector.ContainsShape containsShapeOptimization(Context context, Shape shape) {
        return this.getShapes(context).contains(shape) ? InternalSelector.ContainsShape.YES : InternalSelector.ContainsShape.NO;
    }
}

