/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.AttributeComparator;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;

final class AttributeSelector
implements InternalSelector {
    private final List<String> path;
    private final List<AttributeValue> expected;
    private final AttributeComparator comparator;
    private final boolean caseInsensitive;
    private final Function<Model, Collection<? extends Shape>> optimizer;

    AttributeSelector(List<String> path, List<String> expected, AttributeComparator comparator, boolean caseInsensitive) {
        this.path = path;
        this.caseInsensitive = caseInsensitive;
        this.comparator = comparator;
        if (expected == null) {
            this.expected = Collections.emptyList();
        } else {
            this.expected = new ArrayList<AttributeValue>(expected.size());
            for (String validValue : expected) {
                this.expected.add(AttributeValue.literal(validValue));
            }
        }
        this.optimizer = comparator == null && path.size() >= 2 && path.get(0).equals("trait") && !path.get(1).startsWith("(") ? model -> {
            String absoluteShapeId = Trait.makeAbsoluteName((String)path.get(1));
            ShapeId trait = ShapeId.from(absoluteShapeId);
            return model.getShapesWithTrait(trait);
        } : Model::toSet;
    }

    static AttributeSelector existence(List<String> path) {
        return new AttributeSelector(path, null, null, false);
    }

    @Override
    public Collection<? extends Shape> getStartingShapes(Model model) {
        return this.optimizer.apply(model);
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        if (this.matchesAttribute(shape, context)) {
            return next.apply(context, shape);
        }
        return InternalSelector.Response.CONTINUE;
    }

    private boolean matchesAttribute(Shape shape, Context stack) {
        AttributeValue lhs = AttributeValue.shape(shape, stack.getVars()).getPath(this.path);
        if (this.comparator == null) {
            return lhs.isPresent();
        }
        for (AttributeValue rhs : this.expected) {
            if (!this.comparator.compare(lhs, rhs, this.caseInsensitive)) continue;
            return true;
        }
        return false;
    }
}

