/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ExamplesTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ExamplesTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(ExamplesTrait.class)) {
            events.addAll(this.validateExamples(model, operation, operation.expectTrait(ExamplesTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateExamples(Model model, OperationShape shape, ExamplesTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<ExamplesTrait.Example> examples = trait.getExamples();
        for (ExamplesTrait.Example example : examples) {
            boolean isOutputDefined = example.getOutput().isPresent();
            boolean isErrorDefined = example.getError().isPresent();
            model.getShape(shape.getInputShape()).ifPresent(input -> {
                if (example.getAllowConstraintErrors() && !isErrorDefined) {
                    events.add(this.error((Shape)shape, trait, String.format("Example: `%s` has allowConstraintErrors enabled, so error must be defined.", example.getTitle())));
                }
                NodeValidationVisitor validator = this.createVisitor("input", example.getInput(), model, shape, example);
                List<ValidationEvent> inputValidationEvents = input.accept(validator);
                events.addAll(inputValidationEvents);
            });
            if (isOutputDefined && isErrorDefined) {
                events.add(this.error((Shape)shape, trait, String.format("Example: `%s` has both output and error defined, only one should be present.", example.getTitle())));
                continue;
            }
            if (isOutputDefined) {
                model.getShape(shape.getOutputShape()).ifPresent(output -> {
                    NodeValidationVisitor validator = this.createVisitor("output", example.getOutput().get(), model, shape, example);
                    events.addAll((Collection)output.accept(validator));
                });
                continue;
            }
            if (!isErrorDefined) continue;
            ExamplesTrait.ErrorExample errorExample = example.getError().get();
            Optional<Shape> errorShape = model.getShape(errorExample.getShapeId());
            if (errorShape.isPresent() && shape.getErrors().contains(errorExample.getShapeId())) {
                NodeValidationVisitor validator = this.createVisitor("error", errorExample.getContent(), model, shape, example);
                events.addAll((Collection<ValidationEvent>)errorShape.get().accept(validator));
                continue;
            }
            events.add(this.error((Shape)shape, trait, String.format("Error parameters provided for operation without the `%s` error: `%s`", errorExample.getShapeId(), example.getTitle())));
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(String name, ObjectNode value, Model model, Shape shape, ExamplesTrait.Example example) {
        NodeValidationVisitor.Builder builder = NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value(value).startingContext("Example " + name + " of `" + example.getTitle() + "`").eventId(this.getName());
        if (example.getAllowConstraintErrors()) {
            builder.addFeature(NodeValidationVisitor.Feature.ALLOW_CONSTRAINT_ERRORS);
        }
        return builder.build();
    }
}

