/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SetUtils;

public final class DeprecatedTraitValidator
extends AbstractValidator {
    private static final Set<ShapeId> HANDLED_ELSEWHERE = SetUtils.of((Object)EnumTrait.ID);

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape trait : model.getShapesWithTrait(TraitDefinition.class)) {
            Set<Shape> shapesWithTrait;
            if (!trait.hasTrait(DeprecatedTrait.class) || HANDLED_ELSEWHERE.contains(trait.toShapeId()) || (shapesWithTrait = model.getShapesWithTrait(trait)).isEmpty()) continue;
            DeprecatedTrait deprecatedTrait = trait.expectTrait(DeprecatedTrait.class);
            String traitMessage = trait.toShapeId().toString();
            if (deprecatedTrait.getMessage().isPresent()) {
                traitMessage = traitMessage + ", " + deprecatedTrait.getMessage().get();
            }
            for (Shape shape : shapesWithTrait) {
                if (Prelude.isPreludeShape(shape)) continue;
                events.add(this.warning(shape, shape.findTrait(trait.getId()).get(), String.format("This shape applies a trait that is deprecated: %s", traitMessage)));
            }
        }
        return events;
    }
}

