/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NamedMemberUtils;
import software.amazon.smithy.model.shapes.NamedMembersShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class UnionShape
extends Shape
implements ToSmithyBuilder<UnionShape> {
    private final Map<String, MemberShape> members;

    private UnionShape(Builder builder) {
        super(builder, false);
        this.members = NamedMemberUtils.computeMixinMembers(builder.getMixins(), (BuilderRef<Map<String, MemberShape>>)builder.members, this.getId(), this.getSourceLocation());
        this.validateMemberShapeIds();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.updateBuilder(UnionShape.builder());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> visitor) {
        return visitor.unionShape(this);
    }

    @Override
    public Optional<UnionShape> asUnionShape() {
        return Optional.of(this);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.UNION;
    }

    @Override
    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public static final class Builder
    extends NamedMembersShapeBuilder<Builder, UnionShape> {
        public UnionShape build() {
            return new UnionShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.UNION;
        }
    }
}

