/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NamedMemberUtils;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;

abstract class NamedMembersShapeBuilder<B extends NamedMembersShapeBuilder<B, S>, S extends Shape>
extends AbstractShapeBuilder<B, S> {
    protected final BuilderRef<Map<String, MemberShape>> members = BuilderRef.forOrderedMap();

    NamedMembersShapeBuilder() {
    }

    @Override
    public Optional<MemberShape> getMember(String memberName) {
        return Optional.ofNullable((MemberShape)((Map)this.members.get()).get(memberName));
    }

    @Override
    public final B id(ShapeId shapeId) {
        for (MemberShape member : ((Map)this.members.peek()).values()) {
            this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
        }
        return (B)((NamedMembersShapeBuilder)super.id(shapeId));
    }

    public B members(Collection<MemberShape> members) {
        this.clearMembers();
        for (MemberShape member : members) {
            this.addMember(member);
        }
        return (B)this;
    }

    @Override
    public B clearMembers() {
        this.members.clear();
        return (B)this;
    }

    @Override
    public B addMember(MemberShape member) {
        ((Map)this.members.get()).put(member.getMemberName(), member);
        return (B)this;
    }

    public B addMember(String memberName, ShapeId target) {
        return this.addMember(memberName, target, null);
    }

    public B addMember(String memberName, ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
        if (this.getId() == null) {
            throw new IllegalStateException("An id must be set before setting a member with a target");
        }
        MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember(memberName));
        if (memberUpdater != null) {
            memberUpdater.accept(builder);
        }
        return (B)this.addMember(builder.build());
    }

    public B removeMember(String member) {
        if (this.members.hasValue()) {
            ((Map)this.members.get()).remove(member);
        }
        return (B)this;
    }

    @Override
    public B addMixin(Shape shape) {
        if (this.getId() == null) {
            throw new IllegalStateException("An id must be set before adding a mixin");
        }
        super.addMixin(shape);
        NamedMemberUtils.cleanMixins(shape, (Map)this.members.get());
        return (B)this;
    }

    @Override
    public B removeMixin(ToShapeId shape) {
        super.removeMixin(shape);
        NamedMemberUtils.removeMixin(shape, (Map)this.members.get());
        return (B)this;
    }

    @Override
    public B flattenMixins() {
        if (this.getMixins().isEmpty()) {
            return (B)this;
        }
        this.members(NamedMemberUtils.flattenMixins((Map)this.members.get(), this.getMixins(), this.getId(), this.getSourceLocation()));
        return (B)((NamedMembersShapeBuilder)super.flattenMixins());
    }
}

