/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class AndSelector {
    private AndSelector() {
    }

    static InternalSelector of(List<InternalSelector> selectors) {
        switch (selectors.size()) {
            case 0: {
                return InternalSelector.IDENTITY;
            }
            case 1: {
                return selectors.get(0);
            }
            case 2: {
                return new IntermediateAndSelector(selectors.get(0), selectors.get(1));
            }
        }
        InternalSelector result = selectors.get(selectors.size() - 1);
        for (int i = selectors.size() - 2; i >= 0; --i) {
            result = new IntermediateAndSelector(selectors.get(i), result);
        }
        return result;
    }

    static final class IntermediateAndSelector
    implements InternalSelector {
        private final InternalSelector leftSelector;
        private final InternalSelector rightSelector;

        IntermediateAndSelector(InternalSelector leftSelector, InternalSelector rightSelector) {
            this.leftSelector = leftSelector;
            this.rightSelector = rightSelector;
        }

        @Override
        public InternalSelector.Response push(Context ctx, Shape shape, InternalSelector.Receiver next) {
            return this.leftSelector.push(ctx, shape, (c, s) -> this.rightSelector.push(c, s, next));
        }

        @Override
        public Collection<? extends Shape> getStartingShapes(Model model) {
            return this.leftSelector.getStartingShapes(model);
        }
    }
}

