/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.neighbor.UnreferencedShapes;
import software.amazon.smithy.model.neighbor.UnreferencedTraitDefinitions;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.AddClientOptional;
import software.amazon.smithy.model.transform.ChangeShapeType;
import software.amazon.smithy.model.transform.ChangeShapeTypeOption;
import software.amazon.smithy.model.transform.CopyServiceErrorsToOperationsTransform;
import software.amazon.smithy.model.transform.CreateDedicatedInputAndOutput;
import software.amazon.smithy.model.transform.DowngradeToV1;
import software.amazon.smithy.model.transform.FilterMetadata;
import software.amazon.smithy.model.transform.FilterShapes;
import software.amazon.smithy.model.transform.FilterTraits;
import software.amazon.smithy.model.transform.FlattenAndRemoveMixins;
import software.amazon.smithy.model.transform.MapShapes;
import software.amazon.smithy.model.transform.MapTraits;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.model.transform.RemoveInvalidDefaults;
import software.amazon.smithy.model.transform.RemoveShapes;
import software.amazon.smithy.model.transform.RenameShapes;
import software.amazon.smithy.model.transform.ReplaceShapes;
import software.amazon.smithy.model.transform.ScrubTraitDefinitions;
import software.amazon.smithy.model.transform.SortMembers;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.ListUtils;

public final class ModelTransformer {
    private final List<ModelTransformerPlugin> plugins;

    private ModelTransformer(List<ModelTransformerPlugin> plugins) {
        this.plugins = ListUtils.copyOf(plugins);
    }

    public static ModelTransformer create() {
        return DefaultHolder.INSTANCE;
    }

    private static ModelTransformer createWithServiceLoader(ServiceLoader<ModelTransformerPlugin> serviceLoader) {
        ArrayList<ModelTransformerPlugin> plugins = new ArrayList<ModelTransformerPlugin>();
        serviceLoader.forEach(plugins::add);
        return ModelTransformer.createWithPlugins(plugins);
    }

    public static ModelTransformer createWithPlugins(List<ModelTransformerPlugin> plugins) {
        return new ModelTransformer(plugins);
    }

    public static ModelTransformer createWithServiceProviders(ClassLoader classLoader) {
        return ModelTransformer.createWithServiceLoader(ServiceLoader.load(ModelTransformerPlugin.class, classLoader));
    }

    public Model replaceShapes(Model model, Collection<? extends Shape> shapes) {
        if (shapes.isEmpty()) {
            return model;
        }
        return new ReplaceShapes(shapes).transform(this, model);
    }

    public Model removeShapes(Model model, Collection<? extends Shape> shapes) {
        if (shapes.isEmpty()) {
            return model;
        }
        return new RemoveShapes(shapes, this.plugins).transform(this, model);
    }

    public Model removeShapesIf(Model model, Predicate<Shape> predicate) {
        return this.filterShapes(model, FunctionalUtils.not(predicate));
    }

    public Model renameShapes(Model model, Map<ShapeId, ShapeId> renamed) {
        return this.renameShapes(model, renamed, () -> Model.assembler().disableValidation());
    }

    public Model renameShapes(Model model, Map<ShapeId, ShapeId> renamed, Supplier<ModelAssembler> modelAssemblerSupplier) {
        return new RenameShapes(renamed, modelAssemblerSupplier).transform(this, model);
    }

    public Model filterShapes(Model model, Predicate<Shape> predicate) {
        return new FilterShapes(predicate).transform(this, model);
    }

    public Model filterTraits(Model model, BiPredicate<Shape, Trait> predicate) {
        return new FilterTraits(predicate).transform(this, model);
    }

    public Model removeTraitsIf(Model model, BiPredicate<Shape, Trait> predicate) {
        return this.filterTraits(model, predicate.negate());
    }

    public Model filterMetadata(Model model, BiPredicate<String, Node> predicate) {
        return new FilterMetadata(predicate).transform(model);
    }

    public Model mapTraits(Model model, BiFunction<Shape, Trait, Trait> mapper) {
        return new MapTraits(mapper).transform(this, model);
    }

    public Model mapTraits(Model model, List<BiFunction<Shape, Trait, Trait>> mappers) {
        return this.mapTraits(model, mappers.stream().reduce((a, b) -> (s, t) -> (Trait)b.apply(s, a.apply(s, t))).orElse((s, t) -> t));
    }

    public Model mapShapes(Model model, Function<Shape, Shape> mapper) {
        return new MapShapes(mapper).transform(this, model);
    }

    public Model mapShapes(Model model, List<Function<Shape, Shape>> mappers) {
        return this.mapShapes(model, mappers.stream().reduce(Function::compose).orElse(Function.identity()));
    }

    public Model removeUnreferencedShapes(Model model) {
        return this.removeUnreferencedShapes(model, FunctionalUtils.alwaysTrue());
    }

    public Model removeUnreferencedShapes(Model model, Predicate<Shape> keepFilter) {
        return this.removeShapes(model, new UnreferencedShapes(keepFilter).compute(model));
    }

    public Model removeUnreferencedTraitDefinitions(Model model) {
        return this.removeUnreferencedTraitDefinitions(model, FunctionalUtils.alwaysTrue());
    }

    public Model removeUnreferencedTraitDefinitions(Model model, Predicate<Shape> keepFilter) {
        return this.removeShapes(model, new UnreferencedTraitDefinitions(keepFilter).compute(model));
    }

    public Model scrubTraitDefinitions(Model model) {
        return this.scrubTraitDefinitions(model, FunctionalUtils.alwaysTrue());
    }

    public Model scrubTraitDefinitions(Model model, Predicate<Shape> keepFilter) {
        return new ScrubTraitDefinitions().transform(this, model, keepFilter);
    }

    public Model getModelWithoutTraitShapes(Model model) {
        return this.getModelWithoutTraitShapes(model, FunctionalUtils.alwaysTrue());
    }

    public Model getModelWithoutTraitShapes(Model model, Predicate<Shape> keepFilter) {
        Model.Builder builder = Model.builder();
        this.scrubTraitDefinitions(model, keepFilter).shapes().map(Shape::getId).map(model::getShape).map(Optional::get).forEach(builder::addShape);
        return builder.build();
    }

    public Model sortMembers(Model model, Comparator<MemberShape> comparator) {
        return new SortMembers(comparator).transform(this, model);
    }

    public Model changeShapeType(Model model, Map<ShapeId, ShapeType> shapeToType) {
        return new ChangeShapeType(shapeToType).transform(this, model);
    }

    public Model changeShapeType(Model model, Map<ShapeId, ShapeType> shapeToType, ChangeShapeTypeOption ... changeShapeTypeOptions) {
        boolean synthesizeNames = ChangeShapeTypeOption.SYNTHESIZE_ENUM_NAMES.hasFeature(changeShapeTypeOptions);
        return new ChangeShapeType(shapeToType, synthesizeNames).transform(this, model);
    }

    public Model changeStringEnumsToEnumShapes(Model model, boolean synthesizeEnumNames) {
        return ChangeShapeType.upgradeEnums(model, synthesizeEnumNames).transform(this, model);
    }

    public Model changeStringEnumsToEnumShapes(Model model) {
        return ChangeShapeType.upgradeEnums(model, false).transform(this, model);
    }

    public Model downgradeEnums(Model model) {
        return ChangeShapeType.downgradeEnums(model).transform(this, model);
    }

    public Model copyServiceErrorsToOperations(Model model, ServiceShape forService) {
        return new CopyServiceErrorsToOperationsTransform(forService).transform(this, model);
    }

    public Model createDedicatedInputAndOutput(Model model, String inputSuffix, String outputSuffix) {
        return new CreateDedicatedInputAndOutput(inputSuffix, outputSuffix).transform(this, model);
    }

    public Model flattenAndRemoveMixins(Model model) {
        return new FlattenAndRemoveMixins().transform(this, model);
    }

    public Model addClientOptional(Model model, boolean applyWhenNoDefaultValue) {
        return new AddClientOptional(applyWhenNoDefaultValue).transform(this, model);
    }

    public Model downgradeToV1(Model model) {
        return new DowngradeToV1().transform(this, model);
    }

    public Model removeInvalidDefaults(Model model) {
        return new RemoveInvalidDefaults().transform(this, model);
    }

    private static class DefaultHolder {
        static final ModelTransformer INSTANCE = ModelTransformer.createWithServiceProviders(ModelTransformer.class.getClassLoader());

        private DefaultHolder() {
        }
    }
}

