/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class FlattenAndRemoveMixins {
    FlattenAndRemoveMixins() {
    }

    Model transform(ModelTransformer transformer, Model model) {
        ArrayList<Shape> updatedShapes = new ArrayList<Shape>();
        ArrayList<ShapeId> toRemove = new ArrayList<ShapeId>();
        for (Shape shape : model.toSet()) {
            if (shape.hasTrait(MixinTrait.class)) {
                toRemove.add(shape.getId());
                continue;
            }
            if (shape.getMixins().isEmpty()) continue;
            updatedShapes.add((Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).flattenMixins().build());
        }
        if (!updatedShapes.isEmpty()) {
            Model.Builder builder = model.toBuilder();
            updatedShapes.forEach(builder::addShape);
            toRemove.forEach(builder::removeShape);
            model = builder.build();
        }
        return model;
    }
}

