/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CorsTrait
extends AbstractTrait
implements ToSmithyBuilder<CorsTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#cors");
    private static final String DEFAULT_ORIGIN = "*";
    private static final int DEFAULT_MAX_AGE = 600;
    private final String origin;
    private final int maxAge;
    private final Set<String> additionalAllowedHeaders;
    private final Set<String> additionalExposedHeaders;

    private CorsTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.origin = builder.origin;
        this.maxAge = builder.maxAge;
        this.additionalAllowedHeaders = SetUtils.copyOf((Collection)builder.additionalAllowedHeaders);
        this.additionalExposedHeaders = SetUtils.copyOf((Collection)builder.additionalExposedHeaders);
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public Set<String> getAdditionalAllowedHeaders() {
        return this.additionalAllowedHeaders;
    }

    public Set<String> getAdditionalExposedHeaders() {
        return this.additionalExposedHeaders;
    }

    public Builder toBuilder() {
        return ((Builder)CorsTrait.builder().sourceLocation(this.getSourceLocation())).origin(this.origin).maxAge(this.maxAge).additionalAllowedHeaders(this.additionalAllowedHeaders).additionalExposedHeaders(this.additionalExposedHeaders);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("origin", Optional.of(this.origin).filter(val -> !val.equals(DEFAULT_ORIGIN)).map(Node::from)).withOptionalMember("maxAge", Optional.of(this.maxAge).filter(val -> !val.equals(600)).map(Node::from)).withOptionalMember("additionalAllowedHeaders", Optional.of(this.additionalAllowedHeaders).filter(FunctionalUtils.not(Set::isEmpty)).map(Node::fromStrings)).withOptionalMember("additionalExposedHeaders", Optional.of(this.additionalExposedHeaders).filter(FunctionalUtils.not(Set::isEmpty)).map(Node::fromStrings));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CorsTrait)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        CorsTrait trait = (CorsTrait)other;
        return this.origin.equals(trait.origin) && this.maxAge == trait.maxAge && this.additionalAllowedHeaders.equals(trait.additionalAllowedHeaders) && this.additionalExposedHeaders.equals(trait.additionalExposedHeaders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toShapeId(), this.origin, this.maxAge, this.additionalAllowedHeaders, this.additionalExposedHeaders);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public CorsTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)CorsTrait.builder().sourceLocation(value);
            value.expectObjectNode().getStringMember("origin", builder::origin).getNumberMember("maxAge", n -> builder.maxAge(n.intValue())).getMember("additionalAllowedHeaders", Node::expectArrayNode, a -> builder.additionalAllowedHeaders(Provider.stringSetFromNode(a))).getMember("additionalExposedHeaders", Node::expectArrayNode, a -> builder.additionalExposedHeaders(Provider.stringSetFromNode(a)));
            CorsTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }

        private static Set<String> stringSetFromNode(ArrayNode node) {
            HashSet<String> result = new HashSet<String>(node.size());
            for (Node value : node.getElements()) {
                result.add(value.expectStringNode().getValue());
            }
            return result;
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<CorsTrait, Builder> {
        private String origin = "*";
        private int maxAge = 600;
        private Set<String> additionalAllowedHeaders = SetUtils.of();
        private Set<String> additionalExposedHeaders = SetUtils.of();

        private Builder() {
        }

        public Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin);
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder additionalAllowedHeaders(Set<String> additionalAllowedHeaders) {
            this.additionalAllowedHeaders = SetUtils.caseInsensitiveCopyOf(additionalAllowedHeaders);
            return this;
        }

        public Builder additionalExposedHeaders(Set<String> additionalExposedHeaders) {
            this.additionalExposedHeaders = SetUtils.caseInsensitiveCopyOf(additionalExposedHeaders);
            return this;
        }

        public CorsTrait build() {
            return new CorsTrait(this);
        }
    }
}

