/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.math.BigDecimal;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

class RangeTraitPlugin
implements NodeValidatorPlugin {
    private static final String MEMBER = "Member";
    private static final String TARGET = "Target";

    RangeTraitPlugin() {
    }

    @Override
    public final void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, NodeValidatorPlugin.Emitter emitter) {
        if (shape.hasTrait(RangeTrait.class)) {
            if (value.isNumberNode()) {
                boolean zeroValueWarning = context.hasFeature(NodeValidationVisitor.Feature.RANGE_TRAIT_ZERO_VALUE_WARNING);
                this.check(shape, zeroValueWarning, shape.expectTrait(RangeTrait.class), value.expectNumberNode(), emitter);
            } else if (value.isStringNode()) {
                this.checkNonNumeric(shape, shape.expectTrait(RangeTrait.class), value.expectStringNode(), emitter);
            }
        }
    }

    private void checkNonNumeric(Shape shape, RangeTrait trait, StringNode node, NodeValidatorPlugin.Emitter emitter) {
        Node.NonNumericFloat.fromStringRepresentation(node.getValue()).ifPresent(value -> {
            if (value.equals((Object)Node.NonNumericFloat.NAN)) {
                emitter.accept(node, Severity.ERROR, String.format("Value provided for `%s` must be a number because the `smithy.api#range` trait is applied, but found \"%s\"", shape.getId(), node.getValue()));
            }
            if (trait.getMin().isPresent() && value.equals((Object)Node.NonNumericFloat.NEGATIVE_INFINITY)) {
                emitter.accept(node, Severity.ERROR, String.format("Value provided for `%s` must be greater than or equal to %s, but found \"%s\"", shape.getId(), trait.getMin().get(), node.getValue()), shape.isMemberShape() ? MEMBER : TARGET);
            }
            if (trait.getMax().isPresent() && value.equals((Object)Node.NonNumericFloat.POSITIVE_INFINITY)) {
                emitter.accept(node, Severity.ERROR, String.format("Value provided for `%s` must be less than or equal to %s, but found \"%s\"", shape.getId(), trait.getMax().get(), node.getValue()), shape.isMemberShape() ? MEMBER : TARGET);
            }
        });
    }

    protected void check(Shape shape, boolean zeroValueWarning, RangeTrait trait, NumberNode node, NodeValidatorPlugin.Emitter emitter) {
        Number number = node.getValue();
        BigDecimal decimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        trait.getMin().ifPresent(min -> {
            if (decimal.compareTo(new BigDecimal(min.toString())) < 0) {
                emitter.accept(node, this.getSeverity(node, zeroValueWarning), String.format("Value provided for `%s` must be greater than or equal to %s, but found %s", shape.getId(), min, number), shape.isMemberShape() ? MEMBER : TARGET);
            }
        });
        trait.getMax().ifPresent(max -> {
            if (decimal.compareTo(new BigDecimal(max.toString())) > 0) {
                emitter.accept(node, this.getSeverity(node, zeroValueWarning), String.format("Value provided for `%s` must be less than or equal to %s, but found %s", shape.getId(), max, number), shape.isMemberShape() ? MEMBER : TARGET);
            }
        });
    }

    private Severity getSeverity(NumberNode node, boolean zeroValueWarning) {
        return zeroValueWarning && node.isZero() ? Severity.WARNING : Severity.ERROR;
    }
}

