/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ValidationUtils {
    private static final Pattern CAMEL_WORD_SPLITTER = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    private ValidationUtils() {
    }

    public static List<String> splitCamelCaseWord(String word) {
        return Arrays.asList(CAMEL_WORD_SPLITTER.split(word));
    }

    public static String orderedTickedList(Collection<?> values) {
        if (values.size() == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("`, `", "`", "`");
        for (Object value : values) {
            joiner.add(value.toString());
        }
        return joiner.toString();
    }

    public static String tickedList(Collection<?> values) {
        ArrayList valueList = new ArrayList(values);
        valueList.sort(Comparator.comparing(Object::toString));
        return ValidationUtils.orderedTickedList(valueList);
    }

    public static String tickedList(Stream<?> values) {
        return values.map(Object::toString).sorted().collect(Collectors.joining("`, `", "`", "`"));
    }

    @Deprecated
    public static <T extends ToShapeId> Map<String, List<ShapeId>> findDuplicateShapeNames(Collection<T> shapes) {
        return shapes.stream().map(ToShapeId::toShapeId).filter(id -> !id.hasMember()).collect(Collectors.groupingBy(id -> id.getName().toLowerCase(Locale.US))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            ((List)entry.getValue()).sort(Comparator.comparing(ShapeId::toString));
            return (List)entry.getValue();
        }, (a, b) -> b, LinkedHashMap::new));
    }
}

