/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;

final class NamedMemberUtils {
    private NamedMemberUtils() {
    }

    static Map<String, MemberShape> computeMixinMembers(Map<ShapeId, Shape> mixins, BuilderRef<Map<String, MemberShape>> members, ShapeId shapeId, SourceLocation sourceLocation) {
        if (mixins.isEmpty()) {
            return (Map)members.copy();
        }
        LinkedHashMap<String, MemberShape> computedMembers = new LinkedHashMap<String, MemberShape>();
        for (Shape shape : mixins.values()) {
            for (MemberShape member : shape.members()) {
                String name = member.getMemberName();
                if (((Map)members.get()).containsKey(name)) {
                    MemberShape localMember = (MemberShape)((Map)members.get()).get(name);
                    if (localMember.getMixins().isEmpty() || !mixins.containsKey(member.getId())) {
                        localMember = ((MemberShape.Builder)((MemberShape.Builder)localMember.toBuilder().clearMixins()).addMixin(member)).build();
                    }
                    computedMembers.put(name, localMember);
                    continue;
                }
                MemberShape previouslyDefined = (MemberShape)computedMembers.get(name);
                if (previouslyDefined != null) {
                    NamedMemberUtils.validateMixinMemberConflict(member, previouslyDefined);
                    computedMembers.put(name, ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)previouslyDefined.toBuilder().source(member.getSourceLocation())).addMixin(member)).addTraits(member.getAllTraits().values())).build());
                    continue;
                }
                computedMembers.put(name, ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(shapeId.withMember(name))).target(member.getTarget()).source(member.getSourceLocation())).addMixin(member)).build());
            }
        }
        for (MemberShape member : ((Map)members.get()).values()) {
            if (computedMembers.containsKey(member.getMemberName())) continue;
            computedMembers.put(member.getMemberName(), member);
        }
        return Collections.unmodifiableMap(computedMembers);
    }

    static Set<MemberShape> flattenMixins(Map<String, MemberShape> members, Map<ShapeId, Shape> mixins, ShapeId shapeId, SourceLocation sourceLocation) {
        LinkedHashMap<String, MemberShape> orderedMembers = new LinkedHashMap<String, MemberShape>();
        LinkedHashMap<String, MemberShape> pendingMembers = new LinkedHashMap<String, MemberShape>();
        for (Shape shape : mixins.values()) {
            for (MemberShape member : shape.members()) {
                String memberName = member.getMemberName();
                MemberShape existing = members.remove(memberName);
                if (existing != null) {
                    pendingMembers.put(memberName, existing);
                }
                MemberShape previouslyDefined = (MemberShape)orderedMembers.get(memberName);
                Collection<Object> previousTraits = Collections.emptyList();
                if (previouslyDefined != null) {
                    previousTraits = previouslyDefined.getAllTraits().values();
                    NamedMemberUtils.validateMixinMemberConflict(member, previouslyDefined);
                }
                orderedMembers.put(memberName, ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(shapeId.withMember(memberName))).target(member.getTarget()).addTraits(previousTraits)).addTraits(member.getAllTraits().values())).source(member.getSourceLocation())).build());
            }
        }
        for (Map.Entry entry : pendingMembers.entrySet()) {
            String memberName = (String)entry.getKey();
            MemberShape existing = (MemberShape)entry.getValue();
            MemberShape needUpdate = (MemberShape)orderedMembers.get(memberName);
            orderedMembers.put(memberName, ((MemberShape.Builder)((MemberShape.Builder)needUpdate.toBuilder().source(existing.getSourceLocation())).addTraits(existing.getIntroducedTraits().values())).build());
        }
        orderedMembers.putAll(members);
        return new LinkedHashSet<MemberShape>(orderedMembers.values());
    }

    static void validateMixinMemberConflict(MemberShape member, MemberShape previouslyDefined) {
        if (!previouslyDefined.getTarget().equals(member.getTarget())) {
            throw new SourceException("Member conflicts with an inherited mixin member: `" + previouslyDefined.getId() + "`", member);
        }
    }

    static void cleanMixins(Shape newMixin, Map<String, MemberShape> members) {
        members.values().removeIf(member -> {
            if (!NamedMemberUtils.isMemberMixedInFromShape(newMixin.getId(), member)) {
                return false;
            }
            for (MemberShape mixinMember : newMixin.members()) {
                if (!mixinMember.getMemberName().equals(member.getMemberName())) continue;
                return false;
            }
            return true;
        });
    }

    static void removeMixin(ToShapeId mixin, Map<String, MemberShape> members) {
        ShapeId id = mixin.toShapeId();
        members.values().removeIf(member -> NamedMemberUtils.isMemberMixedInFromShape(id, member));
    }

    private static boolean isMemberMixedInFromShape(ShapeId check, MemberShape member) {
        if (member.getMixins().contains(check)) {
            return true;
        }
        for (ShapeId memberMixin : member.getMixins()) {
            if (!memberMixin.withoutMember().equals(check)) continue;
            return true;
        }
        return false;
    }
}

