/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class InSelector
implements InternalSelector {
    private final InternalSelector selector;

    InSelector(InternalSelector selector) {
        this.selector = selector;
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        switch (this.selector.containsShapeOptimization(context, shape)) {
            case YES: {
                return next.apply(context, shape);
            }
            case NO: {
                return InternalSelector.Response.CONTINUE;
            }
        }
        FilteredHolder holder = new FilteredHolder(shape);
        this.selector.push(context, shape, holder);
        if (holder.matched) {
            return next.apply(context, shape);
        }
        return InternalSelector.Response.CONTINUE;
    }

    private static final class FilteredHolder
    implements InternalSelector.Receiver {
        private final Shape shapeToMatch;
        private boolean matched;

        FilteredHolder(Shape shapeToMatch) {
            this.shapeToMatch = shapeToMatch;
        }

        @Override
        public InternalSelector.Response apply(Context context, Shape shape) {
            if (shape.equals(this.shapeToMatch)) {
                this.matched = true;
                return InternalSelector.Response.STOP;
            }
            return InternalSelector.Response.CONTINUE;
        }
    }
}

