/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.LoadOperation;
import software.amazon.smithy.model.loader.LoadOperationProcessor;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelInteropTransformer;
import software.amazon.smithy.model.loader.ModelLoader;
import software.amazon.smithy.model.loader.ModelValidator;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.Pair;

public final class ModelAssembler {
    public static final String ALLOW_UNKNOWN_TRAITS = "assembler.allowUnknownTraits";
    public static final String DISABLE_JAR_CACHE = "assembler.disableJarCache";
    private static final Logger LOGGER = Logger.getLogger(ModelAssembler.class.getName());
    private static final Consumer<ValidationEvent> DEFAULT_EVENT_LISTENER = ValidationEvent2 -> {};
    private TraitFactory traitFactory;
    private ValidatorFactory validatorFactory;
    private boolean disableValidation;
    private final Map<String, Supplier<InputStream>> inputStreamModels = new HashMap<String, Supplier<InputStream>>();
    private final List<Validator> validators = new ArrayList<Validator>();
    private final List<Node> documentNodes = new ArrayList<Node>();
    private final List<Model> mergeModels = new ArrayList<Model>();
    private final List<Shape> shapes = new ArrayList<Shape>();
    private final List<Pair<ShapeId, Trait>> pendingTraits = new ArrayList<Pair<ShapeId, Trait>>();
    private final Map<String, Node> metadata = new HashMap<String, Node>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean disablePrelude;
    private Consumer<ValidationEvent> validationEventListener = DEFAULT_EVENT_LISTENER;

    public ModelAssembler copy() {
        ModelAssembler assembler = new ModelAssembler();
        assembler.traitFactory = this.traitFactory;
        assembler.validatorFactory = this.validatorFactory;
        assembler.inputStreamModels.putAll(this.inputStreamModels);
        assembler.validators.addAll(this.validators);
        assembler.documentNodes.addAll(this.documentNodes);
        assembler.mergeModels.addAll(this.mergeModels);
        assembler.shapes.addAll(this.shapes);
        assembler.pendingTraits.addAll(this.pendingTraits);
        assembler.metadata.putAll(this.metadata);
        assembler.disablePrelude = this.disablePrelude;
        assembler.properties.putAll(this.properties);
        assembler.disableValidation = this.disableValidation;
        assembler.validationEventListener = this.validationEventListener;
        return assembler;
    }

    public ModelAssembler reset() {
        this.shapes.clear();
        this.pendingTraits.clear();
        this.metadata.clear();
        this.mergeModels.clear();
        this.inputStreamModels.clear();
        this.validators.clear();
        this.documentNodes.clear();
        this.disablePrelude = false;
        this.disableValidation = false;
        this.validationEventListener = DEFAULT_EVENT_LISTENER;
        return this;
    }

    public ModelAssembler traitFactory(TraitFactory traitFactory) {
        this.traitFactory = Objects.requireNonNull(traitFactory);
        return this;
    }

    public ModelAssembler validatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = Objects.requireNonNull(validatorFactory);
        return this;
    }

    public ModelAssembler addValidator(Validator validator) {
        this.validators.add(Objects.requireNonNull(validator));
        return this;
    }

    public ModelAssembler addUnparsedModel(String sourceLocation, String model) {
        this.inputStreamModels.put(sourceLocation, () -> new ByteArrayInputStream(model.getBytes(StandardCharsets.UTF_8)));
        return this;
    }

    public ModelAssembler addDocumentNode(Node document) {
        this.documentNodes.add(Objects.requireNonNull(document));
        return this;
    }

    public ModelAssembler addImport(String importPath) {
        return this.addImport(Paths.get(Objects.requireNonNull(importPath, "importPath must not be null"), new String[0]));
    }

    public ModelAssembler addImport(Path importPath) {
        block17: {
            Objects.requireNonNull(importPath, "The importPath provided to ModelAssembler#addImport was null");
            if (Files.isDirectory(importPath, new LinkOption[0])) {
                try (Stream<Path> files = Files.walk(importPath, FileVisitOption.FOLLOW_LINKS).filter(p -> !p.equals(importPath)).filter(p -> Files.isDirectory(p, new LinkOption[0]) || Files.isRegularFile(p, new LinkOption[0]));){
                    files.forEach(this::addImport);
                    break block17;
                }
                catch (IOException e) {
                    throw new ModelImportException("Error loading the contents of " + importPath, e);
                }
            }
            if (Files.isRegularFile(importPath, new LinkOption[0])) {
                this.inputStreamModels.put(importPath.toString(), () -> {
                    try {
                        return Files.newInputStream(importPath, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new ModelImportException("Unable to import Smithy model from " + importPath + ": " + e.getMessage(), e);
                    }
                });
            } else {
                throw new ModelImportException("Cannot find import file: " + importPath);
            }
        }
        return this;
    }

    public ModelAssembler addImport(URL url) {
        Objects.requireNonNull(url, "The provided url to ModelAssembler#addImport was null");
        String key = url.toExternalForm();
        if (key.startsWith("file:")) {
            try {
                key = Paths.get(url.toURI()).toString();
            }
            catch (URISyntaxException e) {
                key = key.substring(5);
            }
        }
        this.inputStreamModels.put(key, () -> {
            try {
                URLConnection connection = url.openConnection();
                if (this.properties.containsKey(DISABLE_JAR_CACHE)) {
                    connection.setUseCaches(false);
                }
                return connection.getInputStream();
            }
            catch (IOException | UncheckedIOException e) {
                throw new ModelImportException("Unable to open Smithy model import URL: " + url.toExternalForm(), e);
            }
        });
        return this;
    }

    public ModelAssembler disablePrelude() {
        this.disablePrelude = true;
        return this;
    }

    public ModelAssembler addShape(Shape shape) {
        this.shapes.add(shape);
        return this;
    }

    public ModelAssembler addShapes(Shape ... shapes) {
        for (Shape shape : shapes) {
            this.addShape(shape);
        }
        return this;
    }

    public ModelAssembler addTrait(ShapeId target, Trait trait) {
        this.pendingTraits.add((Pair<ShapeId, Trait>)Pair.of((Object)target, (Object)trait));
        return this;
    }

    public ModelAssembler addModel(Model model) {
        this.mergeModels.add(model);
        return this;
    }

    public ModelAssembler putMetadata(String name, Node value) {
        this.metadata.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
        return this;
    }

    public ModelAssembler discoverModels(ClassLoader loader) {
        return this.addDiscoveredModels(ModelDiscovery.findModels(loader));
    }

    public ModelAssembler discoverModels() {
        return this.addDiscoveredModels(ModelDiscovery.findModels());
    }

    private ModelAssembler addDiscoveredModels(List<URL> urls) {
        for (URL url : urls) {
            LOGGER.fine(() -> "Discovered Smithy model: " + url);
            this.addImport(url);
        }
        return this;
    }

    public ModelAssembler putProperty(String setting, Object value) {
        this.properties.put(setting, value);
        return this;
    }

    public ModelAssembler removeProperty(String setting) {
        this.properties.remove(setting);
        return this;
    }

    public ModelAssembler disableValidation() {
        this.disableValidation = true;
        return this;
    }

    public ModelAssembler validationEventListener(Consumer<ValidationEvent> eventListener) {
        this.validationEventListener = eventListener == null ? DEFAULT_EVENT_LISTENER : eventListener;
        return this;
    }

    public ValidatedResult<Model> assemble() {
        Model model;
        if (this.traitFactory == null) {
            this.traitFactory = LazyTraitFactoryHolder.INSTANCE;
        }
        Model prelude = this.disablePrelude ? null : Prelude.getPreludeModel();
        LoadOperationProcessor processor = new LoadOperationProcessor(this.traitFactory, prelude, this.areUnknownTraitsAllowed(), this.validationEventListener);
        List<ValidationEvent> events = processor.events();
        this.addMetadataToProcessor(this.metadata, processor);
        this.shapes.forEach(processor::putCreatedShape);
        for (Pair<ShapeId, Trait> pair : this.pendingTraits) {
            processor.accept(LoadOperation.ApplyTrait.from((ShapeId)pair.getKey(), (Trait)pair.getValue()));
        }
        for (Model model2 : this.mergeModels) {
            this.addMetadataToProcessor(model2.getMetadata(), processor);
            model2.shapes().forEach(processor::putCreatedShape);
        }
        for (Node node : this.documentNodes) {
            try {
                ModelLoader.loadParsedNode(node, processor);
            }
            catch (SourceException e) {
                processor.accept(new LoadOperation.Event(ValidationEvent.fromSourceException(e)));
            }
        }
        for (Map.Entry entry : this.inputStreamModels.entrySet()) {
            try {
                ModelLoader.load(this.traitFactory, this.properties, (String)entry.getKey(), processor, (Supplier)entry.getValue());
            }
            catch (SourceException e) {
                processor.accept(new LoadOperation.Event(ValidationEvent.fromSourceException(e)));
            }
        }
        Model processedModel = processor.buildModel();
        try {
            model = new ModelInteropTransformer(processedModel, events, processor::getShapeVersion).transform();
        }
        catch (SourceException e) {
            LOGGER.log(Level.SEVERE, "Error in ModelInteropTransformer: ", e);
            events.add(ValidationEvent.fromSourceException(e));
            return new ValidatedResult<Model>(processedModel, events);
        }
        if (LoaderUtils.containsErrorEvents(events)) {
            return this.returnOnlyErrors(model, events);
        }
        if (this.disableValidation) {
            return new ValidatedResult<Model>(model, events);
        }
        try {
            return this.validate(model, events);
        }
        catch (SourceException e) {
            events.add(ValidationEvent.fromSourceException(e));
            return new ValidatedResult<Model>(model, events);
        }
    }

    private void addMetadataToProcessor(Map<String, Node> metadataMap, LoadOperationProcessor processor) {
        for (Map.Entry<String, Node> entry : metadataMap.entrySet()) {
            processor.accept(new LoadOperation.PutMetadata(Version.UNKNOWN, entry.getKey(), entry.getValue()));
        }
    }

    private ValidatedResult<Model> returnOnlyErrors(Model model, List<ValidationEvent> events) {
        return new ValidatedResult<Model>(model, events.stream().filter(event -> event.getSeverity() == Severity.ERROR).collect(Collectors.toList()));
    }

    private ValidatedResult<Model> validate(Model model, List<ValidationEvent> events) {
        List<ValidationEvent> mergedEvents = new ModelValidator().validators(this.validators).validatorFactory(this.validatorFactory).eventListener(this.validationEventListener).includeEvents(events).createValidator().validate(model);
        return new ValidatedResult<Model>(model, mergedEvents);
    }

    private boolean areUnknownTraitsAllowed() {
        Object allowUnknown = this.properties.get(ALLOW_UNKNOWN_TRAITS);
        return allowUnknown != null && (Boolean)allowUnknown != false;
    }

    static final class LazyTraitFactoryHolder {
        static final TraitFactory INSTANCE = TraitFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        LazyTraitFactoryHolder() {
        }
    }
}

