/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ModelUpgrader {
    private static final EnumSet<ShapeType> HAD_DEFAULT_VALUE_IN_1_0 = EnumSet.of(ShapeType.BYTE, new ShapeType[]{ShapeType.SHORT, ShapeType.INTEGER, ShapeType.LONG, ShapeType.FLOAT, ShapeType.DOUBLE, ShapeType.BOOLEAN});
    private final Model model;
    private final List<ValidationEvent> events;
    private final Function<Shape, Version> fileToVersion;
    private final List<Shape> shapeUpgrades = new ArrayList<Shape>();

    ModelUpgrader(Model model, List<ValidationEvent> events, Function<Shape, Version> fileToVersion) {
        this.model = model;
        this.events = events;
        this.fileToVersion = fileToVersion;
    }

    ValidatedResult<Model> transform() {
        for (StructureShape struct : this.model.getStructureShapes()) {
            if (Prelude.isPreludeShape(struct) || this.fileToVersion.apply(struct) != Version.VERSION_1_0) continue;
            for (MemberShape member : struct.getAllMembers().values()) {
                this.model.getShape(member.getTarget()).ifPresent(target -> this.upgradeV1Member(member, (Shape)target));
            }
        }
        return new ValidatedResult<Model>(ModelTransformer.create().replaceShapes(this.model, this.shapeUpgrades), this.events);
    }

    private void upgradeV1Member(MemberShape member, Shape target) {
        if (this.shouldV1MemberHaveDefaultTrait(member, target)) {
            this.events.add(ValidationEvent.builder().id("ModelDeprecation").severity(Severity.WARNING).shape(member).message("Add the @default trait to this member to make it forward compatible with Smithy IDL 2.0").build());
            MemberShape.Builder builder = member.toBuilder();
            if (target.isBooleanShape()) {
                builder.addTrait(new DefaultTrait(new BooleanNode(false, builder.getSourceLocation())));
            } else if (target.isBlobShape()) {
                builder.addTrait(new DefaultTrait(new StringNode("", builder.getSourceLocation())));
            } else if (this.isZeroValidDefault(member)) {
                builder.addTrait(new DefaultTrait(new NumberNode(0, builder.getSourceLocation())));
            }
            this.shapeUpgrades.add(builder.build());
        } else if (this.isMemberImplicitlyBoxed(member, target)) {
            MemberShape.Builder builder = member.toBuilder();
            builder.addTrait(new BoxTrait());
            this.shapeUpgrades.add(builder.build());
        }
    }

    private boolean isMemberImplicitlyBoxed(MemberShape member, Shape target) {
        return !member.hasTrait(DefaultTrait.class) && !member.hasTrait(BoxTrait.class) && target.hasTrait(BoxTrait.class);
    }

    private boolean isZeroValidDefault(MemberShape member) {
        Optional<RangeTrait> rangeTraitOptional = member.getMemberTrait(this.model, RangeTrait.class);
        if (!rangeTraitOptional.isPresent()) {
            return true;
        }
        RangeTrait rangeTrait = rangeTraitOptional.get();
        if (rangeTrait.getMin().isPresent() && rangeTrait.getMin().get().compareTo(BigDecimal.ZERO) > 0) {
            this.events.add(ValidationEvent.builder().id("ModelDeprecation").severity(Severity.WARNING).shape(member).message("Cannot add the @default trait to this member due to a minimum range constraint.").build());
            return false;
        }
        if (rangeTrait.getMax().isPresent() && rangeTrait.getMax().get().compareTo(BigDecimal.ZERO) < 0) {
            this.events.add(ValidationEvent.builder().id("ModelDeprecation").severity(Severity.WARNING).shape(member).message("Cannot add the @default trait to this member due to a maximum range constraint.").build());
            return false;
        }
        return true;
    }

    private boolean shouldV1MemberHaveDefaultTrait(MemberShape member, Shape target) {
        return (HAD_DEFAULT_VALUE_IN_1_0.contains((Object)target.getType()) || this.isDefaultPayload(target)) && !member.hasTrait(DefaultTrait.ID) && !member.hasTrait(RequiredTrait.ID) && !member.hasTrait(BoxTrait.ID) && !target.hasTrait(BoxTrait.ID);
    }

    private boolean isDefaultPayload(Shape target) {
        return target.hasTrait(StreamingTrait.ID) && target.isBlobShape();
    }
}

