/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Objects;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.SparseTrait;

public class NullableIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;

    public NullableIndex(Model model) {
        this.model = new WeakReference<Model>(model);
    }

    public static NullableIndex of(Model model) {
        return model.getKnowledge(NullableIndex.class, NullableIndex::new);
    }

    public boolean isMemberNullable(MemberShape member) {
        return this.isMemberNullable(member, CheckMode.CLIENT);
    }

    public boolean isMemberNullable(MemberShape member, CheckMode checkMode) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape container = m.expectShape(member.getContainer());
        Shape target = m.expectShape(member.getTarget());
        switch (container.getType()) {
            case STRUCTURE: {
                return checkMode.isStructureMemberOptional(container.asStructureShape().get(), member, target);
            }
            case UNION: 
            case SET: {
                return false;
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    @Deprecated
    public final boolean isNullable(ToShapeId shapeId) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape shape = m.getShape(shapeId.toShapeId()).orElse(null);
        if (shape == null) {
            return false;
        }
        switch (shape.getType()) {
            case MEMBER: {
                return this.isMemberNullableInV1(m, shape.asMemberShape().get());
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return shape.hasTrait(BoxTrait.class);
            }
        }
        return true;
    }

    private boolean isMemberNullableInV1(Model model, MemberShape member) {
        Shape container = model.getShape(member.getContainer()).orElse(null);
        if (container == null) {
            return false;
        }
        switch (container.getType()) {
            case STRUCTURE: {
                if (member.hasTrait(BoxTrait.class)) {
                    return true;
                }
                return this.isNullable(member.getTarget());
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    public static enum CheckMode {
        CLIENT{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (member.hasTrait(ClientOptionalTrait.class) || container.hasTrait(InputTrait.class)) {
                    return true;
                }
                return SERVER.isStructureMemberOptional(container, member, target);
            }
        }
        ,
        CLIENT_CAREFUL{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (target instanceof StructureShape || target instanceof UnionShape) {
                    return true;
                }
                return CLIENT.isStructureMemberOptional(container, member, target);
            }
        }
        ,
        SERVER{

            @Override
            boolean isStructureMemberOptional(StructureShape container, MemberShape member, Shape target) {
                if (member.hasTrait(DefaultTrait.class)) {
                    return false;
                }
                if (member.hasTrait(BoxTrait.class)) {
                    return true;
                }
                return !member.hasTrait(RequiredTrait.class);
            }
        };


        abstract boolean isStructureMemberOptional(StructureShape var1, MemberShape var2, Shape var3);
    }
}

