/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.NodeDiff;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.node.internal.NodeHandler;
import software.amazon.smithy.utils.IoUtils;

public abstract class Node
implements FromSourceLocation,
ToNode {
    private final SourceLocation sourceLocation;

    Node(SourceLocation sourceLocation) {
        this.sourceLocation = Objects.requireNonNull(sourceLocation);
    }

    public static Node parse(String json) {
        return NodeHandler.parse("", json, false);
    }

    public static Node parse(String json, String file) {
        return NodeHandler.parse(file, json, false);
    }

    public static Node parse(InputStream json) {
        return Node.parse(json, "");
    }

    public static Node parse(InputStream json, String file) {
        return Node.parse(IoUtils.toUtf8String((InputStream)json), file);
    }

    public static Node parseJsonWithComments(String json, String file) {
        return NodeHandler.parse(file, json, true);
    }

    public static Node parseJsonWithComments(String json) {
        return Node.parseJsonWithComments(json, "");
    }

    public static String prettyPrintJson(Node node) {
        return Node.prettyPrintJson(node, "    ");
    }

    public static String prettyPrintJson(Node node, String indentString) {
        return NodeHandler.prettyPrint(node, indentString);
    }

    public static String printJson(Node node) {
        return NodeHandler.print(node);
    }

    public static StringNode from(String value) {
        return new StringNode(value, SourceLocation.none());
    }

    public static NumberNode from(Number number) {
        return new NumberNode(number, SourceLocation.none());
    }

    public static BooleanNode from(boolean value) {
        return new BooleanNode(value, SourceLocation.none());
    }

    public static Node from(ToNode value) {
        return value == null ? Node.nullNode() : value.toNode();
    }

    public static ArrayNode fromNodes(List<? extends Node> values) {
        return new ArrayNode(values, SourceLocation.none());
    }

    public static ArrayNode fromNodes(Node ... values) {
        return Node.fromNodes(Arrays.asList(values));
    }

    public static ArrayNode fromStrings(Collection<String> values) {
        return Node.fromNodes(values.stream().map(Node::from).collect(Collectors.toList()));
    }

    public static ArrayNode fromStrings(String ... values) {
        return Node.fromStrings(Arrays.asList(values));
    }

    public static ObjectNode.Builder objectNodeBuilder() {
        return ObjectNode.builder();
    }

    public static ObjectNode objectNode() {
        return ObjectNode.EMPTY;
    }

    public static ObjectNode objectNode(Map<StringNode, Node> values) {
        return new ObjectNode(values, SourceLocation.none());
    }

    public static ArrayNode arrayNode() {
        return ArrayNode.EMPTY;
    }

    public static ArrayNode arrayNode(Node ... nodes) {
        return new ArrayNode(Arrays.asList(nodes), SourceLocation.none());
    }

    public static NullNode nullNode() {
        return new NullNode(SourceLocation.none());
    }

    public static List<String> loadArrayOfString(String descriptor, Node node) {
        return node.expectArrayNode("Expected `" + descriptor + "` to be an array of strings. Found {type}.").getElements().stream().map(element -> element.expectStringNode("Each element of `" + descriptor + "` must be a string. Found {type}.")).map(StringNode::getValue).collect(Collectors.toList());
    }

    public static void assertEquals(ToNode actual, ToNode expected) {
        Node expectedNode;
        Node actualNode = actual.toNode();
        if (!actualNode.equals(expectedNode = expected.toNode())) {
            throw new ExpectationNotMetException(String.format("Actual node did not match expected Node.%nActual:%n%s%nExpected:%n%s%nDiff: %s", Node.prettyPrintJson(actualNode), Node.prettyPrintJson(expectedNode), String.join((CharSequence)System.lineSeparator(), Node.diff(actualNode, expectedNode))), actualNode);
        }
    }

    public static List<String> diff(ToNode actual, ToNode expected) {
        return NodeDiff.diff(actual, expected);
    }

    public abstract NodeType getType();

    public abstract <R> R accept(NodeVisitor<R> var1);

    public final boolean isObjectNode() {
        return this.getType() == NodeType.OBJECT;
    }

    public final boolean isArrayNode() {
        return this.getType() == NodeType.ARRAY;
    }

    public final boolean isStringNode() {
        return this.getType() == NodeType.STRING;
    }

    public final boolean isNumberNode() {
        return this.getType() == NodeType.NUMBER;
    }

    public final boolean isBooleanNode() {
        return this.getType() == NodeType.BOOLEAN;
    }

    public final boolean isNullNode() {
        return this.getType() == NodeType.NULL;
    }

    public Optional<ObjectNode> asObjectNode() {
        return Optional.empty();
    }

    public Optional<ArrayNode> asArrayNode() {
        return Optional.empty();
    }

    public Optional<StringNode> asStringNode() {
        return Optional.empty();
    }

    public Optional<BooleanNode> asBooleanNode() {
        return Optional.empty();
    }

    public Optional<NumberNode> asNumberNode() {
        return Optional.empty();
    }

    public Optional<NullNode> asNullNode() {
        return Optional.empty();
    }

    public final ObjectNode expectObjectNode() {
        return this.expectObjectNode((String)null);
    }

    public ObjectNode expectObjectNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.OBJECT.toString()), this);
    }

    public ObjectNode expectObjectNode(Supplier<String> message) {
        return this.expectObjectNode(message.get());
    }

    public final ArrayNode expectArrayNode() {
        return this.expectArrayNode((String)null);
    }

    public ArrayNode expectArrayNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.ARRAY.toString()), this);
    }

    public ArrayNode expectArrayNode(Supplier<String> message) {
        return this.expectArrayNode(message.get());
    }

    public final StringNode expectStringNode() {
        return this.expectStringNode((String)null);
    }

    public StringNode expectStringNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.STRING.toString()), this);
    }

    public StringNode expectStringNode(Supplier<String> message) {
        return this.expectStringNode(message.get());
    }

    public final NumberNode expectNumberNode() {
        return this.expectNumberNode((String)null);
    }

    public NumberNode expectNumberNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.NUMBER.toString()), this);
    }

    public NumberNode expectNumberNode(Supplier<String> message) {
        return this.expectNumberNode(message.get());
    }

    public final BooleanNode expectBooleanNode() {
        return this.expectBooleanNode((String)null);
    }

    public BooleanNode expectBooleanNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.BOOLEAN.toString()), this);
    }

    public BooleanNode expectBooleanNode(Supplier<String> message) {
        return this.expectBooleanNode(message.get());
    }

    public final NullNode expectNullNode() {
        return this.expectNullNode((String)null);
    }

    public NullNode expectNullNode(String message) {
        throw new ExpectationNotMetException(this.expandMessage(message, NodeType.NULL.toString()), this);
    }

    public NullNode expectNullNode(Supplier<String> message) {
        return this.expectNullNode(message.get());
    }

    @Override
    public final SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public final Node toNode() {
        return this;
    }

    private String expandMessage(String message, String expectedType) {
        return (message == null ? String.format("Expected %s, but found {type}.", expectedType) : message).replace("{type}", this.getType().toString());
    }

    public final Node withDeepSortedKeys() {
        return this.withDeepSortedKeys(Comparator.comparing(StringNode::getValue));
    }

    public final Node withDeepSortedKeys(Comparator<StringNode> keyComparator) {
        return Node.sortNode(this, keyComparator);
    }

    private static Node sortNode(Node node, final Comparator<StringNode> keyComparator) {
        return node.accept(new NodeVisitor.Default<Node>(){

            @Override
            protected Node getDefault(Node node) {
                return node;
            }

            @Override
            public Node objectNode(ObjectNode node) {
                TreeMap<StringNode, Node> members = new TreeMap<StringNode, Node>(keyComparator);
                node.getMembers().forEach((k, v) -> members.put((StringNode)k, Node.sortNode((Node)v, keyComparator)));
                return new ObjectNode(members, node.getSourceLocation());
            }

            @Override
            public Node arrayNode(ArrayNode node) {
                return node.getElements().stream().map(element -> Node.sortNode((Node)element, keyComparator)).collect(ArrayNode.collect(node.getSourceLocation()));
            }
        });
    }

    public static enum NonNumericFloat {
        NAN("NaN"),
        POSITIVE_INFINITY("Infinity"),
        NEGATIVE_INFINITY("-Infinity");

        private final String stringRepresentation;

        private NonNumericFloat(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String getStringRepresentation() {
            return this.stringRepresentation;
        }

        public static Set<String> stringRepresentations() {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (NonNumericFloat value : NonNumericFloat.values()) {
                values.add(value.getStringRepresentation());
            }
            return values;
        }

        public static Optional<NonNumericFloat> fromStringRepresentation(String value) {
            switch (value) {
                case "NaN": {
                    return Optional.of(NAN);
                }
                case "Infinity": {
                    return Optional.of(POSITIVE_INFINITY);
                }
                case "-Infinity": {
                    return Optional.of(NEGATIVE_INFINITY);
                }
            }
            return Optional.empty();
        }
    }
}

