/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class CollectionShape
extends Shape {
    private final MemberShape member;

    CollectionShape(Builder builder) {
        super(builder, false);
        this.member = (MemberShape)SmithyBuilder.requiredState((String)"member", (Object)builder.member);
        ShapeId expected = this.getId().withMember("member");
        if (!this.member.getId().equals(expected)) {
            throw new IllegalArgumentException(String.format("Expected member of `%s` to have an ID of `%s` but found `%s`", this.getId(), expected, this.member.getId()));
        }
    }

    public final MemberShape getMember() {
        return this.member;
    }

    @Override
    public final Optional<MemberShape> getMember(String name) {
        return name.equals("member") ? Optional.of(this.member) : Optional.empty();
    }

    @Override
    public Collection<MemberShape> members() {
        return Collections.singletonList(this.member);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getMember().equals(((CollectionShape)other).getMember());
    }

    public static abstract class Builder<B extends Builder<?, ?>, S extends CollectionShape>
    extends AbstractShapeBuilder<B, S> {
        private MemberShape member;

        @Override
        public B id(ShapeId shapeId) {
            if (this.member != null) {
                this.member(((MemberShape.Builder)this.member.toBuilder().id(shapeId.withMember(this.member.getMemberName()))).build());
            }
            return (B)((Builder)super.id(shapeId));
        }

        public B member(MemberShape member) {
            this.member = Objects.requireNonNull(member);
            return (B)this;
        }

        public B member(ShapeId target) {
            return this.member(target, null);
        }

        public B member(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("member"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.member(builder.build());
        }

        @Override
        public B addMember(MemberShape member) {
            return this.member(member);
        }
    }
}

