/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import software.amazon.smithy.model.shapes.Shape;

final class ShapeTypeFilteredSet<T extends Shape>
extends AbstractSet<T> {
    private final Set<Shape> shapes;
    private final Class<T> shapeType;
    private volatile int size = -1;

    ShapeTypeFilteredSet(Set<Shape> shapes, Class<T> shapeType) {
        this.shapes = shapes;
        this.shapeType = shapeType;
    }

    @Override
    public boolean contains(Object o) {
        return o.getClass() == this.shapeType && super.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator<T>(this.shapes.iterator(), this.shapeType);
    }

    @Override
    public int size() {
        int result = this.size;
        if (result == -1) {
            result = 0;
            for (Shape shape : this.shapes) {
                if (this.shapeType != shape.getClass()) continue;
                ++result;
            }
            this.size = result;
        }
        return result;
    }

    private static final class FilteredIterator<T extends Shape>
    implements Iterator<T> {
        private final Iterator<Shape> iterator;
        private final Class<T> shapeType;
        private T next;

        FilteredIterator(Iterator<Shape> iterator, Class<T> shapeType) {
            this.iterator = iterator;
            this.shapeType = shapeType;
            this.next = this.computeNext();
        }

        private T computeNext() {
            while (this.iterator.hasNext()) {
                Shape nextCandidate = this.iterator.next();
                if (this.shapeType != nextCandidate.getClass()) continue;
                return (T)nextCandidate;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException("No more shapes in iterator");
            }
            T result = this.next;
            this.next = this.computeNext();
            return result;
        }
    }
}

