/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpApiKeyAuthTrait
extends AbstractTrait
implements ToSmithyBuilder<HttpApiKeyAuthTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#httpApiKeyAuth");
    private final String scheme;
    private final String name;
    private final Location in;

    private HttpApiKeyAuthTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.name = (String)SmithyBuilder.requiredState((String)"name", (Object)builder.name);
        this.in = (Location)((Object)SmithyBuilder.requiredState((String)"in", (Object)((Object)builder.in)));
        this.scheme = builder.scheme;
    }

    public Optional<String> getScheme() {
        return Optional.ofNullable(this.scheme);
    }

    public String getName() {
        return this.name;
    }

    public Location getIn() {
        return this.in;
    }

    public Builder toBuilder() {
        return ((Builder)HttpApiKeyAuthTrait.builder().sourceLocation(this.getSourceLocation())).scheme(this.getScheme().orElse(null)).name(this.getName()).in(this.getIn());
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember("name", this.getName()).withMember("in", this.getIn().toString()).withOptionalMember("scheme", this.getScheme().map(Node::from));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<HttpApiKeyAuthTrait, Builder> {
        private String scheme;
        private String name;
        private Location in;

        private Builder() {
        }

        public HttpApiKeyAuthTrait build() {
            return new HttpApiKeyAuthTrait(this);
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder in(Location in) {
            this.in = in;
            return this;
        }
    }

    public static enum Location {
        HEADER("header"),
        QUERY("query");

        private final String serialized;

        private Location(String serialized) {
            this.serialized = serialized;
        }

        static Location from(String value) {
            for (Location location : Location.values()) {
                if (!location.serialized.equals(value)) continue;
                return location;
            }
            throw new IllegalArgumentException("Invalid location type: " + value);
        }

        public String toString() {
            return this.serialized;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)HttpApiKeyAuthTrait.builder().sourceLocation(value.getSourceLocation());
            builder.scheme(objectNode.getStringMemberOrDefault("scheme", null));
            builder.name(objectNode.expectStringMember("name").getValue());
            builder.in(Location.from(objectNode.expectStringMember("in").expectOneOf("header", "query")));
            HttpApiKeyAuthTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

