/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PaginatedTrait
extends AbstractTrait
implements ToSmithyBuilder<PaginatedTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#paginated");
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final String items;
    private final String inputToken;
    private final String outputToken;
    private final String pageSize;

    private PaginatedTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.inputToken = builder.inputToken;
        this.outputToken = builder.outputToken;
        this.items = builder.items;
        this.pageSize = builder.pageSize;
    }

    public Optional<String> getItems() {
        return Optional.ofNullable(this.items);
    }

    public Optional<String> getInputToken() {
        return Optional.ofNullable(this.inputToken);
    }

    public Optional<String> getOutputToken() {
        return Optional.ofNullable(this.outputToken);
    }

    public Optional<String> getPageSize() {
        return Optional.ofNullable(this.pageSize);
    }

    @Deprecated
    public static Optional<MemberShape> resolvePath(String path, Model model, StructureShape shape) {
        List<MemberShape> memberShapes = PaginatedTrait.resolveFullPath(path, model, shape);
        if (memberShapes.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(memberShapes.get(memberShapes.size() - 1));
    }

    public static List<MemberShape> resolveFullPath(String path, Model model, StructureShape shape) {
        ArrayList<MemberShape> memberShapes = new ArrayList<MemberShape>();
        Optional<StructureShape> container = Optional.of(shape);
        for (String memberName : PATH_PATTERN.split(path)) {
            Optional memberShape = container.flatMap(structure -> structure.getMember(memberName));
            if (!memberShape.isPresent()) {
                return ListUtils.of();
            }
            memberShapes.add((MemberShape)memberShape.get());
            container = model.getShape(((MemberShape)memberShape.get()).getTarget()).flatMap(Shape::asStructureShape);
        }
        return memberShapes;
    }

    public PaginatedTrait merge(PaginatedTrait other) {
        if (other == null) {
            return this;
        }
        return ((Builder)PaginatedTrait.builder().inputToken(this.inputToken != null ? this.inputToken : other.inputToken).outputToken(this.outputToken != null ? this.outputToken : other.outputToken).pageSize(this.pageSize != null ? this.pageSize : other.pageSize).items(this.items != null ? this.items : other.items).sourceLocation(this.getSourceLocation())).build();
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("inputToken", this.getInputToken().map(Node::from)).withOptionalMember("outputToken", this.getOutputToken().map(Node::from)).withOptionalMember("items", this.getItems().map(Node::from)).withOptionalMember("pageSize", this.getPageSize().map(Node::from));
    }

    public Builder toBuilder() {
        return ((Builder)PaginatedTrait.builder().sourceLocation(this.getSourceLocation())).items(this.items).inputToken(this.inputToken).outputToken(this.outputToken).pageSize(this.pageSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<PaginatedTrait, Builder> {
        private String items;
        private String inputToken;
        private String outputToken;
        private String pageSize;

        public Builder items(String memberName) {
            this.items = memberName;
            return this;
        }

        public Builder inputToken(String memberName) {
            this.inputToken = memberName;
            return this;
        }

        public Builder outputToken(String memberName) {
            this.outputToken = memberName;
            return this;
        }

        public Builder pageSize(String memberName) {
            this.pageSize = memberName;
            return this;
        }

        public PaginatedTrait build() {
            return new PaginatedTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public PaginatedTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)PaginatedTrait.builder().sourceLocation(value);
            ObjectNode members = value.expectObjectNode();
            builder.pageSize(members.getStringMemberOrDefault("pageSize", null));
            builder.items(members.getStringMemberOrDefault("items", null));
            builder.inputToken(members.getStringMemberOrDefault("inputToken", null));
            builder.outputToken(members.getStringMemberOrDefault("outputToken", null));
            return builder.build();
        }
    }
}

